// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediatailor.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediatailor.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service, including detailed information about the settings covered in this guide, see the [AWS Elemental MediaTailor User Guide](https://docs.aws.amazon.com/mediatailor/latest/ug/).
 *
 * Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do through the console. For example, you specify ad insertion behavior and mapping information for the origin server and the ad decision server (ADS).
 */
interface MediaTailorClient : SdkClient {

    override val serviceName: String
        get() = "MediaTailor"
    /**
     * MediaTailorClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MediaTailorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaTailorClient(config)
        }

        operator fun invoke(config: Config): MediaTailorClient = DefaultMediaTailorClient(config)

        /**
         * Construct a [MediaTailorClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaTailorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaTailorClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Configures Amazon CloudWatch log settings for a playback configuration.
     */
    suspend fun configureLogsForPlaybackConfiguration(input: ConfigureLogsForPlaybackConfigurationRequest): ConfigureLogsForPlaybackConfigurationResponse

    /**
     * Configures Amazon CloudWatch log settings for a playback configuration.
     */
    suspend fun configureLogsForPlaybackConfiguration(block: ConfigureLogsForPlaybackConfigurationRequest.Builder.() -> Unit) = configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a channel.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a channel.
     */
    suspend fun createChannel(block: CreateChannelRequest.Builder.() -> Unit) = createChannel(CreateChannelRequest.Builder().apply(block).build())

    /**
     * Creates name for a specific live source in a source location.
     */
    suspend fun createLiveSource(input: CreateLiveSourceRequest): CreateLiveSourceResponse

    /**
     * Creates name for a specific live source in a source location.
     */
    suspend fun createLiveSource(block: CreateLiveSourceRequest.Builder.() -> Unit) = createLiveSource(CreateLiveSourceRequest.Builder().apply(block).build())

    /**
     * Creates a new prefetch schedule for the specified playback configuration.
     */
    suspend fun createPrefetchSchedule(input: CreatePrefetchScheduleRequest): CreatePrefetchScheduleResponse

    /**
     * Creates a new prefetch schedule for the specified playback configuration.
     */
    suspend fun createPrefetchSchedule(block: CreatePrefetchScheduleRequest.Builder.() -> Unit) = createPrefetchSchedule(CreatePrefetchScheduleRequest.Builder().apply(block).build())

    /**
     * Creates a program.
     */
    suspend fun createProgram(input: CreateProgramRequest): CreateProgramResponse

    /**
     * Creates a program.
     */
    suspend fun createProgram(block: CreateProgramRequest.Builder.() -> Unit) = createProgram(CreateProgramRequest.Builder().apply(block).build())

    /**
     * Creates a source location on a specific channel.
     */
    suspend fun createSourceLocation(input: CreateSourceLocationRequest): CreateSourceLocationResponse

    /**
     * Creates a source location on a specific channel.
     */
    suspend fun createSourceLocation(block: CreateSourceLocationRequest.Builder.() -> Unit) = createSourceLocation(CreateSourceLocationRequest.Builder().apply(block).build())

    /**
     * Creates name for a specific VOD source in a source location.
     */
    suspend fun createVodSource(input: CreateVodSourceRequest): CreateVodSourceResponse

    /**
     * Creates name for a specific VOD source in a source location.
     */
    suspend fun createVodSource(block: CreateVodSourceRequest.Builder.() -> Unit) = createVodSource(CreateVodSourceRequest.Builder().apply(block).build())

    /**
     * Deletes a channel. You must stop the channel before it can be deleted.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes a channel. You must stop the channel before it can be deleted.
     */
    suspend fun deleteChannel(block: DeleteChannelRequest.Builder.() -> Unit) = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

    /**
     * Deletes a channel's IAM policy.
     */
    suspend fun deleteChannelPolicy(input: DeleteChannelPolicyRequest): DeleteChannelPolicyResponse

    /**
     * Deletes a channel's IAM policy.
     */
    suspend fun deleteChannelPolicy(block: DeleteChannelPolicyRequest.Builder.() -> Unit) = deleteChannelPolicy(DeleteChannelPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes a specific live source in a specific source location.
     */
    suspend fun deleteLiveSource(input: DeleteLiveSourceRequest): DeleteLiveSourceResponse

    /**
     * Deletes a specific live source in a specific source location.
     */
    suspend fun deleteLiveSource(block: DeleteLiveSourceRequest.Builder.() -> Unit) = deleteLiveSource(DeleteLiveSourceRequest.Builder().apply(block).build())

    /**
     * Deletes the playback configuration for the specified name.
     */
    suspend fun deletePlaybackConfiguration(input: DeletePlaybackConfigurationRequest): DeletePlaybackConfigurationResponse

    /**
     * Deletes the playback configuration for the specified name.
     */
    suspend fun deletePlaybackConfiguration(block: DeletePlaybackConfigurationRequest.Builder.() -> Unit) = deletePlaybackConfiguration(DeletePlaybackConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun deletePrefetchSchedule(input: DeletePrefetchScheduleRequest): DeletePrefetchScheduleResponse

    /**
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun deletePrefetchSchedule(block: DeletePrefetchScheduleRequest.Builder.() -> Unit) = deletePrefetchSchedule(DeletePrefetchScheduleRequest.Builder().apply(block).build())

    /**
     * Deletes a specific program on a specific channel.
     */
    suspend fun deleteProgram(input: DeleteProgramRequest): DeleteProgramResponse

    /**
     * Deletes a specific program on a specific channel.
     */
    suspend fun deleteProgram(block: DeleteProgramRequest.Builder.() -> Unit) = deleteProgram(DeleteProgramRequest.Builder().apply(block).build())

    /**
     * Deletes a source location on a specific channel.
     */
    suspend fun deleteSourceLocation(input: DeleteSourceLocationRequest): DeleteSourceLocationResponse

    /**
     * Deletes a source location on a specific channel.
     */
    suspend fun deleteSourceLocation(block: DeleteSourceLocationRequest.Builder.() -> Unit) = deleteSourceLocation(DeleteSourceLocationRequest.Builder().apply(block).build())

    /**
     * Deletes a specific VOD source in a specific source location.
     */
    suspend fun deleteVodSource(input: DeleteVodSourceRequest): DeleteVodSourceResponse

    /**
     * Deletes a specific VOD source in a specific source location.
     */
    suspend fun deleteVodSource(block: DeleteVodSourceRequest.Builder.() -> Unit) = deleteVodSource(DeleteVodSourceRequest.Builder().apply(block).build())

    /**
     * Describes the properties of a specific channel.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Describes the properties of a specific channel.
     */
    suspend fun describeChannel(block: DescribeChannelRequest.Builder.() -> Unit) = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

    /**
     * Provides details about a specific live source in a specific source location.
     */
    suspend fun describeLiveSource(input: DescribeLiveSourceRequest): DescribeLiveSourceResponse

    /**
     * Provides details about a specific live source in a specific source location.
     */
    suspend fun describeLiveSource(block: DescribeLiveSourceRequest.Builder.() -> Unit) = describeLiveSource(DescribeLiveSourceRequest.Builder().apply(block).build())

    /**
     * Retrieves the properties of the requested program.
     */
    suspend fun describeProgram(input: DescribeProgramRequest): DescribeProgramResponse

    /**
     * Retrieves the properties of the requested program.
     */
    suspend fun describeProgram(block: DescribeProgramRequest.Builder.() -> Unit) = describeProgram(DescribeProgramRequest.Builder().apply(block).build())

    /**
     * Retrieves the properties of the requested source location.
     */
    suspend fun describeSourceLocation(input: DescribeSourceLocationRequest): DescribeSourceLocationResponse

    /**
     * Retrieves the properties of the requested source location.
     */
    suspend fun describeSourceLocation(block: DescribeSourceLocationRequest.Builder.() -> Unit) = describeSourceLocation(DescribeSourceLocationRequest.Builder().apply(block).build())

    /**
     * Provides details about a specific VOD source in a specific source location.
     */
    suspend fun describeVodSource(input: DescribeVodSourceRequest): DescribeVodSourceResponse

    /**
     * Provides details about a specific VOD source in a specific source location.
     */
    suspend fun describeVodSource(block: DescribeVodSourceRequest.Builder.() -> Unit) = describeVodSource(DescribeVodSourceRequest.Builder().apply(block).build())

    /**
     * Retrieves information about a channel's IAM policy.
     */
    suspend fun getChannelPolicy(input: GetChannelPolicyRequest): GetChannelPolicyResponse

    /**
     * Retrieves information about a channel's IAM policy.
     */
    suspend fun getChannelPolicy(block: GetChannelPolicyRequest.Builder.() -> Unit) = getChannelPolicy(GetChannelPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves information about your channel's schedule.
     */
    suspend fun getChannelSchedule(input: GetChannelScheduleRequest): GetChannelScheduleResponse

    /**
     * Retrieves information about your channel's schedule.
     */
    suspend fun getChannelSchedule(block: GetChannelScheduleRequest.Builder.() -> Unit) = getChannelSchedule(GetChannelScheduleRequest.Builder().apply(block).build())

    /**
     * Returns the playback configuration for the specified name.
     */
    suspend fun getPlaybackConfiguration(input: GetPlaybackConfigurationRequest): GetPlaybackConfigurationResponse

    /**
     * Returns the playback configuration for the specified name.
     */
    suspend fun getPlaybackConfiguration(block: GetPlaybackConfigurationRequest.Builder.() -> Unit) = getPlaybackConfiguration(GetPlaybackConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns information about the prefetch schedule for a specific playback configuration. If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun getPrefetchSchedule(input: GetPrefetchScheduleRequest): GetPrefetchScheduleResponse

    /**
     * Returns information about the prefetch schedule for a specific playback configuration. If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    suspend fun getPrefetchSchedule(block: GetPrefetchScheduleRequest.Builder.() -> Unit) = getPrefetchSchedule(GetPrefetchScheduleRequest.Builder().apply(block).build())

    /**
     * Returns a list of alerts for the given resource.
     */
    suspend fun listAlerts(input: ListAlertsRequest): ListAlertsResponse

    /**
     * Returns a list of alerts for the given resource.
     */
    suspend fun listAlerts(block: ListAlertsRequest.Builder.() -> Unit) = listAlerts(ListAlertsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of channels that are associated with this account.
     */
    suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Retrieves a list of channels that are associated with this account.
     */
    suspend fun listChannels(block: ListChannelsRequest.Builder.() -> Unit) = listChannels(ListChannelsRequest.Builder().apply(block).build())

    /**
     * lists all the live sources in a source location.
     */
    suspend fun listLiveSources(input: ListLiveSourcesRequest): ListLiveSourcesResponse

    /**
     * lists all the live sources in a source location.
     */
    suspend fun listLiveSources(block: ListLiveSourcesRequest.Builder.() -> Unit) = listLiveSources(ListLiveSourcesRequest.Builder().apply(block).build())

    /**
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.
     */
    suspend fun listPlaybackConfigurations(input: ListPlaybackConfigurationsRequest = ListPlaybackConfigurationsRequest {}): ListPlaybackConfigurationsResponse

    /**
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.
     */
    suspend fun listPlaybackConfigurations(block: ListPlaybackConfigurationsRequest.Builder.() -> Unit) = listPlaybackConfigurations(ListPlaybackConfigurationsRequest.Builder().apply(block).build())

    /**
     * Creates a new prefetch schedule.
     */
    suspend fun listPrefetchSchedules(input: ListPrefetchSchedulesRequest): ListPrefetchSchedulesResponse

    /**
     * Creates a new prefetch schedule.
     */
    suspend fun listPrefetchSchedules(block: ListPrefetchSchedulesRequest.Builder.() -> Unit) = listPrefetchSchedules(ListPrefetchSchedulesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of source locations.
     */
    suspend fun listSourceLocations(input: ListSourceLocationsRequest = ListSourceLocationsRequest {}): ListSourceLocationsResponse

    /**
     * Retrieves a list of source locations.
     */
    suspend fun listSourceLocations(block: ListSourceLocationsRequest.Builder.() -> Unit) = listSourceLocations(ListSourceLocationsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the tags assigned to the specified playback configuration resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags assigned to the specified playback configuration resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists all the VOD sources in a source location.
     */
    suspend fun listVodSources(input: ListVodSourcesRequest): ListVodSourcesResponse

    /**
     * Lists all the VOD sources in a source location.
     */
    suspend fun listVodSources(block: ListVodSourcesRequest.Builder.() -> Unit) = listVodSources(ListVodSourcesRequest.Builder().apply(block).build())

    /**
     * Creates an IAM policy for the channel.
     */
    suspend fun putChannelPolicy(input: PutChannelPolicyRequest): PutChannelPolicyResponse

    /**
     * Creates an IAM policy for the channel.
     */
    suspend fun putChannelPolicy(block: PutChannelPolicyRequest.Builder.() -> Unit) = putChannelPolicy(PutChannelPolicyRequest.Builder().apply(block).build())

    /**
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     */
    suspend fun putPlaybackConfiguration(input: PutPlaybackConfigurationRequest = PutPlaybackConfigurationRequest {}): PutPlaybackConfigurationResponse

    /**
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     */
    suspend fun putPlaybackConfiguration(block: PutPlaybackConfigurationRequest.Builder.() -> Unit) = putPlaybackConfiguration(PutPlaybackConfigurationRequest.Builder().apply(block).build())

    /**
     * Starts a specific channel.
     */
    suspend fun startChannel(input: StartChannelRequest): StartChannelResponse

    /**
     * Starts a specific channel.
     */
    suspend fun startChannel(block: StartChannelRequest.Builder.() -> Unit) = startChannel(StartChannelRequest.Builder().apply(block).build())

    /**
     * Stops a specific channel.
     */
    suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse

    /**
     * Stops a specific channel.
     */
    suspend fun stopChannel(block: StopChannelRequest.Builder.() -> Unit) = stopChannel(StopChannelRequest.Builder().apply(block).build())

    /**
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an existing channel.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates an existing channel.
     */
    suspend fun updateChannel(block: UpdateChannelRequest.Builder.() -> Unit) = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

    /**
     * Updates a specific live source in a specific source location.
     */
    suspend fun updateLiveSource(input: UpdateLiveSourceRequest): UpdateLiveSourceResponse

    /**
     * Updates a specific live source in a specific source location.
     */
    suspend fun updateLiveSource(block: UpdateLiveSourceRequest.Builder.() -> Unit) = updateLiveSource(UpdateLiveSourceRequest.Builder().apply(block).build())

    /**
     * Updates a source location on a specific channel.
     */
    suspend fun updateSourceLocation(input: UpdateSourceLocationRequest): UpdateSourceLocationResponse

    /**
     * Updates a source location on a specific channel.
     */
    suspend fun updateSourceLocation(block: UpdateSourceLocationRequest.Builder.() -> Unit) = updateSourceLocation(UpdateSourceLocationRequest.Builder().apply(block).build())

    /**
     * Updates a specific VOD source in a specific source location.
     */
    suspend fun updateVodSource(input: UpdateVodSourceRequest): UpdateVodSourceResponse

    /**
     * Updates a specific VOD source in a specific source location.
     */
    suspend fun updateVodSource(block: UpdateVodSourceRequest.Builder.() -> Unit) = updateVodSource(UpdateVodSourceRequest.Builder().apply(block).build())
}
