// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.mediatailor.model.*
import aws.sdk.kotlin.services.mediatailor.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "MediaTailor"
const val ServiceApiVersion: String = "2018-04-23"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultMediaTailorClient(override val config: MediaTailorClient.Config) : MediaTailorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Configures Amazon CloudWatch log settings for a playback configuration.
     */
    override suspend fun configureLogsForPlaybackConfiguration(input: ConfigureLogsForPlaybackConfigurationRequest): ConfigureLogsForPlaybackConfigurationResponse {
        val op = SdkHttpOperation.build<ConfigureLogsForPlaybackConfigurationRequest, ConfigureLogsForPlaybackConfigurationResponse> {
            serializer = ConfigureLogsForPlaybackConfigurationOperationSerializer()
            deserializer = ConfigureLogsForPlaybackConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfigureLogsForPlaybackConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a channel.
     */
    override suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse {
        val op = SdkHttpOperation.build<CreateChannelRequest, CreateChannelResponse> {
            serializer = CreateChannelOperationSerializer()
            deserializer = CreateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates name for a specific live source in a source location.
     */
    override suspend fun createLiveSource(input: CreateLiveSourceRequest): CreateLiveSourceResponse {
        val op = SdkHttpOperation.build<CreateLiveSourceRequest, CreateLiveSourceResponse> {
            serializer = CreateLiveSourceOperationSerializer()
            deserializer = CreateLiveSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLiveSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new prefetch schedule for the specified playback configuration.
     */
    override suspend fun createPrefetchSchedule(input: CreatePrefetchScheduleRequest): CreatePrefetchScheduleResponse {
        val op = SdkHttpOperation.build<CreatePrefetchScheduleRequest, CreatePrefetchScheduleResponse> {
            serializer = CreatePrefetchScheduleOperationSerializer()
            deserializer = CreatePrefetchScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePrefetchSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a program.
     */
    override suspend fun createProgram(input: CreateProgramRequest): CreateProgramResponse {
        val op = SdkHttpOperation.build<CreateProgramRequest, CreateProgramResponse> {
            serializer = CreateProgramOperationSerializer()
            deserializer = CreateProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a source location on a specific channel.
     */
    override suspend fun createSourceLocation(input: CreateSourceLocationRequest): CreateSourceLocationResponse {
        val op = SdkHttpOperation.build<CreateSourceLocationRequest, CreateSourceLocationResponse> {
            serializer = CreateSourceLocationOperationSerializer()
            deserializer = CreateSourceLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSourceLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates name for a specific VOD source in a source location.
     */
    override suspend fun createVodSource(input: CreateVodSourceRequest): CreateVodSourceResponse {
        val op = SdkHttpOperation.build<CreateVodSourceRequest, CreateVodSourceResponse> {
            serializer = CreateVodSourceOperationSerializer()
            deserializer = CreateVodSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVodSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a channel. You must stop the channel before it can be deleted.
     */
    override suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse {
        val op = SdkHttpOperation.build<DeleteChannelRequest, DeleteChannelResponse> {
            serializer = DeleteChannelOperationSerializer()
            deserializer = DeleteChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a channel's IAM policy.
     */
    override suspend fun deleteChannelPolicy(input: DeleteChannelPolicyRequest): DeleteChannelPolicyResponse {
        val op = SdkHttpOperation.build<DeleteChannelPolicyRequest, DeleteChannelPolicyResponse> {
            serializer = DeleteChannelPolicyOperationSerializer()
            deserializer = DeleteChannelPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteChannelPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific live source in a specific source location.
     */
    override suspend fun deleteLiveSource(input: DeleteLiveSourceRequest): DeleteLiveSourceResponse {
        val op = SdkHttpOperation.build<DeleteLiveSourceRequest, DeleteLiveSourceResponse> {
            serializer = DeleteLiveSourceOperationSerializer()
            deserializer = DeleteLiveSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLiveSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the playback configuration for the specified name.
     */
    override suspend fun deletePlaybackConfiguration(input: DeletePlaybackConfigurationRequest): DeletePlaybackConfigurationResponse {
        val op = SdkHttpOperation.build<DeletePlaybackConfigurationRequest, DeletePlaybackConfigurationResponse> {
            serializer = DeletePlaybackConfigurationOperationSerializer()
            deserializer = DeletePlaybackConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeletePlaybackConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    override suspend fun deletePrefetchSchedule(input: DeletePrefetchScheduleRequest): DeletePrefetchScheduleResponse {
        val op = SdkHttpOperation.build<DeletePrefetchScheduleRequest, DeletePrefetchScheduleResponse> {
            serializer = DeletePrefetchScheduleOperationSerializer()
            deserializer = DeletePrefetchScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeletePrefetchSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific program on a specific channel.
     */
    override suspend fun deleteProgram(input: DeleteProgramRequest): DeleteProgramResponse {
        val op = SdkHttpOperation.build<DeleteProgramRequest, DeleteProgramResponse> {
            serializer = DeleteProgramOperationSerializer()
            deserializer = DeleteProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a source location on a specific channel.
     */
    override suspend fun deleteSourceLocation(input: DeleteSourceLocationRequest): DeleteSourceLocationResponse {
        val op = SdkHttpOperation.build<DeleteSourceLocationRequest, DeleteSourceLocationResponse> {
            serializer = DeleteSourceLocationOperationSerializer()
            deserializer = DeleteSourceLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSourceLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific VOD source in a specific source location.
     */
    override suspend fun deleteVodSource(input: DeleteVodSourceRequest): DeleteVodSourceResponse {
        val op = SdkHttpOperation.build<DeleteVodSourceRequest, DeleteVodSourceResponse> {
            serializer = DeleteVodSourceOperationSerializer()
            deserializer = DeleteVodSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVodSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the properties of a specific channel.
     */
    override suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse {
        val op = SdkHttpOperation.build<DescribeChannelRequest, DescribeChannelResponse> {
            serializer = DescribeChannelOperationSerializer()
            deserializer = DescribeChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details about a specific live source in a specific source location.
     */
    override suspend fun describeLiveSource(input: DescribeLiveSourceRequest): DescribeLiveSourceResponse {
        val op = SdkHttpOperation.build<DescribeLiveSourceRequest, DescribeLiveSourceResponse> {
            serializer = DescribeLiveSourceOperationSerializer()
            deserializer = DescribeLiveSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLiveSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the properties of the requested program.
     */
    override suspend fun describeProgram(input: DescribeProgramRequest): DescribeProgramResponse {
        val op = SdkHttpOperation.build<DescribeProgramRequest, DescribeProgramResponse> {
            serializer = DescribeProgramOperationSerializer()
            deserializer = DescribeProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the properties of the requested source location.
     */
    override suspend fun describeSourceLocation(input: DescribeSourceLocationRequest): DescribeSourceLocationResponse {
        val op = SdkHttpOperation.build<DescribeSourceLocationRequest, DescribeSourceLocationResponse> {
            serializer = DescribeSourceLocationOperationSerializer()
            deserializer = DescribeSourceLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSourceLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details about a specific VOD source in a specific source location.
     */
    override suspend fun describeVodSource(input: DescribeVodSourceRequest): DescribeVodSourceResponse {
        val op = SdkHttpOperation.build<DescribeVodSourceRequest, DescribeVodSourceResponse> {
            serializer = DescribeVodSourceOperationSerializer()
            deserializer = DescribeVodSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVodSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a channel's IAM policy.
     */
    override suspend fun getChannelPolicy(input: GetChannelPolicyRequest): GetChannelPolicyResponse {
        val op = SdkHttpOperation.build<GetChannelPolicyRequest, GetChannelPolicyResponse> {
            serializer = GetChannelPolicyOperationSerializer()
            deserializer = GetChannelPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChannelPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about your channel's schedule.
     */
    override suspend fun getChannelSchedule(input: GetChannelScheduleRequest): GetChannelScheduleResponse {
        val op = SdkHttpOperation.build<GetChannelScheduleRequest, GetChannelScheduleResponse> {
            serializer = GetChannelScheduleOperationSerializer()
            deserializer = GetChannelScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChannelSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the playback configuration for the specified name.
     */
    override suspend fun getPlaybackConfiguration(input: GetPlaybackConfigurationRequest): GetPlaybackConfigurationResponse {
        val op = SdkHttpOperation.build<GetPlaybackConfigurationRequest, GetPlaybackConfigurationResponse> {
            serializer = GetPlaybackConfigurationOperationSerializer()
            deserializer = GetPlaybackConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPlaybackConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the prefetch schedule for a specific playback configuration. If you call GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     */
    override suspend fun getPrefetchSchedule(input: GetPrefetchScheduleRequest): GetPrefetchScheduleResponse {
        val op = SdkHttpOperation.build<GetPrefetchScheduleRequest, GetPrefetchScheduleResponse> {
            serializer = GetPrefetchScheduleOperationSerializer()
            deserializer = GetPrefetchScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPrefetchSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of alerts for the given resource.
     */
    override suspend fun listAlerts(input: ListAlertsRequest): ListAlertsResponse {
        val op = SdkHttpOperation.build<ListAlertsRequest, ListAlertsResponse> {
            serializer = ListAlertsOperationSerializer()
            deserializer = ListAlertsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlerts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of channels that are associated with this account.
     */
    override suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse {
        val op = SdkHttpOperation.build<ListChannelsRequest, ListChannelsResponse> {
            serializer = ListChannelsOperationSerializer()
            deserializer = ListChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * lists all the live sources in a source location.
     */
    override suspend fun listLiveSources(input: ListLiveSourcesRequest): ListLiveSourcesResponse {
        val op = SdkHttpOperation.build<ListLiveSourcesRequest, ListLiveSourcesResponse> {
            serializer = ListLiveSourcesOperationSerializer()
            deserializer = ListLiveSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLiveSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.
     */
    override suspend fun listPlaybackConfigurations(input: ListPlaybackConfigurationsRequest): ListPlaybackConfigurationsResponse {
        val op = SdkHttpOperation.build<ListPlaybackConfigurationsRequest, ListPlaybackConfigurationsResponse> {
            serializer = ListPlaybackConfigurationsOperationSerializer()
            deserializer = ListPlaybackConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlaybackConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new prefetch schedule.
     */
    override suspend fun listPrefetchSchedules(input: ListPrefetchSchedulesRequest): ListPrefetchSchedulesResponse {
        val op = SdkHttpOperation.build<ListPrefetchSchedulesRequest, ListPrefetchSchedulesResponse> {
            serializer = ListPrefetchSchedulesOperationSerializer()
            deserializer = ListPrefetchSchedulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPrefetchSchedules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of source locations.
     */
    override suspend fun listSourceLocations(input: ListSourceLocationsRequest): ListSourceLocationsResponse {
        val op = SdkHttpOperation.build<ListSourceLocationsRequest, ListSourceLocationsResponse> {
            serializer = ListSourceLocationsOperationSerializer()
            deserializer = ListSourceLocationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSourceLocations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the tags assigned to the specified playback configuration resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the VOD sources in a source location.
     */
    override suspend fun listVodSources(input: ListVodSourcesRequest): ListVodSourcesResponse {
        val op = SdkHttpOperation.build<ListVodSourcesRequest, ListVodSourcesResponse> {
            serializer = ListVodSourcesOperationSerializer()
            deserializer = ListVodSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVodSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an IAM policy for the channel.
     */
    override suspend fun putChannelPolicy(input: PutChannelPolicyRequest): PutChannelPolicyResponse {
        val op = SdkHttpOperation.build<PutChannelPolicyRequest, PutChannelPolicyResponse> {
            serializer = PutChannelPolicyOperationSerializer()
            deserializer = PutChannelPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutChannelPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     */
    override suspend fun putPlaybackConfiguration(input: PutPlaybackConfigurationRequest): PutPlaybackConfigurationResponse {
        val op = SdkHttpOperation.build<PutPlaybackConfigurationRequest, PutPlaybackConfigurationResponse> {
            serializer = PutPlaybackConfigurationOperationSerializer()
            deserializer = PutPlaybackConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutPlaybackConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a specific channel.
     */
    override suspend fun startChannel(input: StartChannelRequest): StartChannelResponse {
        val op = SdkHttpOperation.build<StartChannelRequest, StartChannelResponse> {
            serializer = StartChannelOperationSerializer()
            deserializer = StartChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a specific channel.
     */
    override suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse {
        val op = SdkHttpOperation.build<StopChannelRequest, StopChannelResponse> {
            serializer = StopChannelOperationSerializer()
            deserializer = StopChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing channel.
     */
    override suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse {
        val op = SdkHttpOperation.build<UpdateChannelRequest, UpdateChannelResponse> {
            serializer = UpdateChannelOperationSerializer()
            deserializer = UpdateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specific live source in a specific source location.
     */
    override suspend fun updateLiveSource(input: UpdateLiveSourceRequest): UpdateLiveSourceResponse {
        val op = SdkHttpOperation.build<UpdateLiveSourceRequest, UpdateLiveSourceResponse> {
            serializer = UpdateLiveSourceOperationSerializer()
            deserializer = UpdateLiveSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLiveSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a source location on a specific channel.
     */
    override suspend fun updateSourceLocation(input: UpdateSourceLocationRequest): UpdateSourceLocationResponse {
        val op = SdkHttpOperation.build<UpdateSourceLocationRequest, UpdateSourceLocationResponse> {
            serializer = UpdateSourceLocationOperationSerializer()
            deserializer = UpdateSourceLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSourceLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specific VOD source in a specific source location.
     */
    override suspend fun updateVodSource(input: UpdateVodSourceRequest): UpdateVodSourceResponse {
        val op = SdkHttpOperation.build<UpdateVodSourceRequest, UpdateVodSourceResponse> {
            serializer = UpdateVodSourceOperationSerializer()
            deserializer = UpdateVodSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVodSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediatailor"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mediatailor")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
