// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.serde

import aws.sdk.kotlin.services.mediastoredata.model.PutObjectRequest
import aws.sdk.kotlin.services.mediastoredata.model.StorageClass
import aws.sdk.kotlin.services.mediastoredata.model.UploadAvailability
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutObjectOperationSerializer: HttpSerialize<PutObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.path) { "path is bound to the URI and must not be null" }
            path.encodedSegments {
                "${input.path}".split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
        }

        builder.headers {
            if (input.cacheControl?.isNotEmpty() == true) append("Cache-Control", input.cacheControl)
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.storageClass != null) append("x-amz-storage-class", input.storageClass.value)
            if (input.uploadAvailability != null) append("x-amz-upload-availability", input.uploadAvailability.value)
        }

        if (input.body != null) {
            builder.body = input.body.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
