// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.serde

import aws.sdk.kotlin.services.mediastoredata.model.MediaStoreDataException
import aws.sdk.kotlin.services.mediastoredata.model.PutObjectResponse
import aws.sdk.kotlin.services.mediastoredata.model.StorageClass
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutObjectOperationDeserializer: HttpDeserialize<PutObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutObjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutObjectError(context, call)
        }
        val builder = PutObjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutObjectOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutObjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaStoreDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "ContainerNotFoundException" -> ContainerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaStoreDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutObjectOperationBody(builder: PutObjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENTSHA256_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContentSHA256"))
    val ETAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ETag"))
    val STORAGECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StorageClass"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTSHA256_DESCRIPTOR)
        field(ETAG_DESCRIPTOR)
        field(STORAGECLASS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENTSHA256_DESCRIPTOR.index -> builder.contentSha256 = deserializeString()
                ETAG_DESCRIPTOR.index -> builder.eTag = deserializeString()
                STORAGECLASS_DESCRIPTOR.index -> builder.storageClass = deserializeString().let { StorageClass.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
