// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.serde

import aws.sdk.kotlin.services.mediastoredata.model.GetObjectResponse
import aws.sdk.kotlin.services.mediastoredata.model.MediaStoreDataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant


internal class GetObjectOperationDeserializer: HttpDeserialize<GetObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetObjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetObjectError(context, call)
        }
        val builder = GetObjectResponse.Builder()

        builder.cacheControl = response.headers["Cache-Control"]
        builder.contentLength = response.headers["Content-Length"]?.toLong()
        builder.contentRange = response.headers["Content-Range"]
        builder.contentType = response.headers["Content-Type"]
        builder.eTag = response.headers["ETag"]
        builder.lastModified = response.headers["Last-Modified"]?.let { Instant.fromRfc5322(it) }

        builder.body = response.body.toByteStream()

        builder.statusCode = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetObjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaStoreDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "RequestedRangeNotSatisfiableException" -> RequestedRangeNotSatisfiableExceptionDeserializer().deserialize(context, wrappedCall)
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ContainerNotFoundException" -> ContainerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaStoreDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
