// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.serde

import aws.sdk.kotlin.services.mediastoredata.model.DeleteObjectResponse
import aws.sdk.kotlin.services.mediastoredata.model.MediaStoreDataException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteObjectOperationDeserializer: HttpDeserialize<DeleteObjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteObjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteObjectError(context, call)
        }
        val builder = DeleteObjectResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteObjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaStoreDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ContainerNotFoundException" -> ContainerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaStoreDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
