// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.model

import aws.smithy.kotlin.runtime.content.ByteStream

public class PutObjectRequest private constructor(builder: Builder) {
    /**
     * The bytes to be stored.
     */
    public val body: aws.smithy.kotlin.runtime.content.ByteStream? = builder.body
    /**
     * An optional `CacheControl` header that allows the caller to control the object's cache behavior. Headers can be passed in as specified in the HTTP at [https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9).
     *
     * Headers with a custom user-defined value are also accepted.
     */
    public val cacheControl: kotlin.String? = builder.cacheControl
    /**
     * The content type of the object.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The path (including the file name) where the object is stored in the container. Format: <folder>/<folder>/<file>
     *
     * For example, to upload the file `mlaw.avi` to the folder path `premium\canada` in the container `movies`, enter the path `premium/canada/mlaw.avi`.
     *
     * Do not include the container name in this path.
     *
     * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing `premium/usa` subfolder. If you specify `premium/canada`, the service creates a `canada` subfolder in the `premium` folder. You then have two subfolders, `usa` and `canada`, in the `premium` folder.
     *
     * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.
     *
     * For more information about folders and how they exist in a container, see the [AWS Elemental MediaStore User Guide](http://docs.aws.amazon.com/mediastore/latest/ug/).
     *
     * The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension.
     */
    public val path: kotlin.String? = builder.path
    /**
     * Indicates the storage class of a `Put` request. Defaults to high-performance temporal storage class, and objects are persisted into durable storage shortly after being received.
     */
    public val storageClass: aws.sdk.kotlin.services.mediastoredata.model.StorageClass? = builder.storageClass
    /**
     * Indicates the availability of an object while it is still uploading. If the value is set to `streaming`, the object is available for downloading after some initial buffering but before the object is uploaded completely. If the value is set to `standard`, the object is available for downloading only when it is uploaded completely. The default value for this header is `standard`.
     *
     * To use this header, you must also set the HTTP `Transfer-Encoding` header to `chunked`.
     */
    public val uploadAvailability: aws.sdk.kotlin.services.mediastoredata.model.UploadAvailability? = builder.uploadAvailability

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastoredata.model.PutObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutObjectRequest(")
        append("body=$body,")
        append("cacheControl=$cacheControl,")
        append("contentType=$contentType,")
        append("path=$path,")
        append("storageClass=$storageClass,")
        append("uploadAvailability=$uploadAvailability")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (cacheControl?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (uploadAvailability?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutObjectRequest

        if (body != other.body) return false
        if (cacheControl != other.cacheControl) return false
        if (contentType != other.contentType) return false
        if (path != other.path) return false
        if (storageClass != other.storageClass) return false
        if (uploadAvailability != other.uploadAvailability) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastoredata.model.PutObjectRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bytes to be stored.
         */
        public var body: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * An optional `CacheControl` header that allows the caller to control the object's cache behavior. Headers can be passed in as specified in the HTTP at [https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9).
         *
         * Headers with a custom user-defined value are also accepted.
         */
        public var cacheControl: kotlin.String? = null
        /**
         * The content type of the object.
         */
        public var contentType: kotlin.String? = null
        /**
         * The path (including the file name) where the object is stored in the container. Format: <folder>/<folder>/<file>
         *
         * For example, to upload the file `mlaw.avi` to the folder path `premium\canada` in the container `movies`, enter the path `premium/canada/mlaw.avi`.
         *
         * Do not include the container name in this path.
         *
         * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing `premium/usa` subfolder. If you specify `premium/canada`, the service creates a `canada` subfolder in the `premium` folder. You then have two subfolders, `usa` and `canada`, in the `premium` folder.
         *
         * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.
         *
         * For more information about folders and how they exist in a container, see the [AWS Elemental MediaStore User Guide](http://docs.aws.amazon.com/mediastore/latest/ug/).
         *
         * The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension.
         */
        public var path: kotlin.String? = null
        /**
         * Indicates the storage class of a `Put` request. Defaults to high-performance temporal storage class, and objects are persisted into durable storage shortly after being received.
         */
        public var storageClass: aws.sdk.kotlin.services.mediastoredata.model.StorageClass? = null
        /**
         * Indicates the availability of an object while it is still uploading. If the value is set to `streaming`, the object is available for downloading after some initial buffering but before the object is uploaded completely. If the value is set to `standard`, the object is available for downloading only when it is uploaded completely. The default value for this header is `standard`.
         *
         * To use this header, you must also set the HTTP `Transfer-Encoding` header to `chunked`.
         */
        public var uploadAvailability: aws.sdk.kotlin.services.mediastoredata.model.UploadAvailability? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastoredata.model.PutObjectRequest) : this() {
            this.body = x.body
            this.cacheControl = x.cacheControl
            this.contentType = x.contentType
            this.path = x.path
            this.storageClass = x.storageClass
            this.uploadAvailability = x.uploadAvailability
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastoredata.model.PutObjectRequest = PutObjectRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
