// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.model



public class ListItemsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return per API request. For example, you submit a `ListItems` request with `MaxResults` set at 500. Although 2,000 items match your request, the service returns no more than the first 500 items. (The service also returns a `NextToken` value that you can use to fetch the next batch of results.) The service might return fewer results than the `MaxResults` value.
     *
     * If `MaxResults` is not included in the request, the service defaults to pagination with a maximum of 1,000 results per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token that identifies which batch of results that you want to see. For example, you submit a `ListItems` request with `MaxResults` set at 500. The service returns the first batch of results (up to 500) and a `NextToken` value. To see the next batch of results, you can submit the `ListItems` request a second time and specify the `NextToken` value.
     *
     * Tokens expire after 15 minutes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The path in the container from which to retrieve items. Format: <folder>/<folder>/<file>
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastoredata.model.ListItemsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListItemsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("path=$path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListItemsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastoredata.model.ListItemsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return per API request. For example, you submit a `ListItems` request with `MaxResults` set at 500. Although 2,000 items match your request, the service returns no more than the first 500 items. (The service also returns a `NextToken` value that you can use to fetch the next batch of results.) The service might return fewer results than the `MaxResults` value.
         *
         * If `MaxResults` is not included in the request, the service defaults to pagination with a maximum of 1,000 results per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token that identifies which batch of results that you want to see. For example, you submit a `ListItems` request with `MaxResults` set at 500. The service returns the first batch of results (up to 500) and a `NextToken` value. To see the next batch of results, you can submit the `ListItems` request a second time and specify the `NextToken` value.
         *
         * Tokens expire after 15 minutes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The path in the container from which to retrieve items. Format: <folder>/<folder>/<file>
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastoredata.model.ListItemsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastoredata.model.ListItemsRequest = ListItemsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
