// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastoredata.model



public class GetObjectRequest private constructor(builder: Builder) {
    /**
     * The path (including the file name) where the object is stored in the container. Format: <folder>/<folder>/<file>
     *
     * For example, to upload the file `mlaw.avi` to the folder path `premium\canada` in the container `movies`, enter the path `premium/canada/mlaw.avi`.
     *
     * Do not include the container name in this path.
     *
     * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing `premium/usa` subfolder. If you specify `premium/canada`, the service creates a `canada` subfolder in the `premium` folder. You then have two subfolders, `usa` and `canada`, in the `premium` folder.
     *
     * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.
     *
     * For more information about folders and how they exist in a container, see the [AWS Elemental MediaStore User Guide](http://docs.aws.amazon.com/mediastore/latest/ug/).
     *
     * The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The range bytes of an object to retrieve. For more information about the `Range` header, see [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35). AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.
     */
    public val range: kotlin.String? = builder.range

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastoredata.model.GetObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectRequest(")
        append("path=$path,")
        append("range=$range")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = path?.hashCode() ?: 0
        result = 31 * result + (range?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectRequest

        if (path != other.path) return false
        if (range != other.range) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastoredata.model.GetObjectRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path (including the file name) where the object is stored in the container. Format: <folder>/<folder>/<file>
         *
         * For example, to upload the file `mlaw.avi` to the folder path `premium\canada` in the container `movies`, enter the path `premium/canada/mlaw.avi`.
         *
         * Do not include the container name in this path.
         *
         * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing `premium/usa` subfolder. If you specify `premium/canada`, the service creates a `canada` subfolder in the `premium` folder. You then have two subfolders, `usa` and `canada`, in the `premium` folder.
         *
         * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.
         *
         * For more information about folders and how they exist in a container, see the [AWS Elemental MediaStore User Guide](http://docs.aws.amazon.com/mediastore/latest/ug/).
         *
         * The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension.
         */
        public var path: kotlin.String? = null
        /**
         * The range bytes of an object to retrieve. For more information about the `Range` header, see [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35). AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.
         */
        public var range: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastoredata.model.GetObjectRequest) : this() {
            this.path = x.path
            this.range = x.range
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastoredata.model.GetObjectRequest = GetObjectRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
