// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A setting that enables metrics at the object level. Each rule contains an object group and an object group name. If the policy includes the MetricPolicyRules parameter, you must include at least one rule. Each metric policy can include up to five rules by default. You can also [request a quota increase](https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas) to allow up to 300 rules per policy.
 */
public class MetricPolicyRule private constructor(builder: Builder) {
    /**
     * A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
     */
    public val objectGroup: kotlin.String = requireNotNull(builder.objectGroup) { "A non-null value must be provided for objectGroup" }
    /**
     * A name that allows you to refer to the object group.
     */
    public val objectGroupName: kotlin.String = requireNotNull(builder.objectGroupName) { "A non-null value must be provided for objectGroupName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastore.model.MetricPolicyRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricPolicyRule(")
        append("objectGroup=$objectGroup,")
        append("objectGroupName=$objectGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = objectGroup.hashCode()
        result = 31 * result + (objectGroupName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricPolicyRule

        if (objectGroup != other.objectGroup) return false
        if (objectGroupName != other.objectGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastore.model.MetricPolicyRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.
         */
        public var objectGroup: kotlin.String? = null
        /**
         * A name that allows you to refer to the object group.
         */
        public var objectGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastore.model.MetricPolicyRule) : this() {
            this.objectGroup = x.objectGroup
            this.objectGroupName = x.objectGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastore.model.MetricPolicyRule = MetricPolicyRule(this)

        internal fun correctErrors(): Builder {
            if (objectGroup == null) objectGroup = ""
            if (objectGroupName == null) objectGroupName = ""
            return this
        }
    }
}
