// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The metric policy that is associated with the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
 *
 * To view examples of how to construct a metric policy for your use case, see [Example Metric Policies](https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html).
 */
public class MetricPolicy private constructor(builder: Builder) {
    /**
     * A setting to enable or disable metrics at the container level.
     */
    public val containerLevelMetrics: aws.sdk.kotlin.services.mediastore.model.ContainerLevelMetrics = requireNotNull(builder.containerLevelMetrics) { "A non-null value must be provided for containerLevelMetrics" }
    /**
     * A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also [request a quota increase](https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas) to allow up to 300 rules per policy.
     */
    public val metricPolicyRules: List<MetricPolicyRule>? = builder.metricPolicyRules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastore.model.MetricPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricPolicy(")
        append("containerLevelMetrics=$containerLevelMetrics,")
        append("metricPolicyRules=$metricPolicyRules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerLevelMetrics.hashCode()
        result = 31 * result + (metricPolicyRules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricPolicy

        if (containerLevelMetrics != other.containerLevelMetrics) return false
        if (metricPolicyRules != other.metricPolicyRules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastore.model.MetricPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A setting to enable or disable metrics at the container level.
         */
        public var containerLevelMetrics: aws.sdk.kotlin.services.mediastore.model.ContainerLevelMetrics? = null
        /**
         * A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also [request a quota increase](https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas) to allow up to 300 rules per policy.
         */
        public var metricPolicyRules: List<MetricPolicyRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastore.model.MetricPolicy) : this() {
            this.containerLevelMetrics = x.containerLevelMetrics
            this.metricPolicyRules = x.metricPolicyRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastore.model.MetricPolicy = MetricPolicy(this)

        internal fun correctErrors(): Builder {
            if (containerLevelMetrics == null) containerLevelMetrics = ContainerLevelMetrics.SdkUnknown("no value provided")
            return this
        }
    }
}
