// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This section describes operations that you can perform on an AWS Elemental MediaStore container.
 */
public class Container private constructor(builder: Builder) {
    /**
     * The state of access logging on the container. This value is `false` by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to `true`, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
     */
    public val accessLoggingEnabled: kotlin.Boolean? = builder.accessLoggingEnabled
    /**
     * The Amazon Resource Name (ARN) of the container. The ARN has the following format:
     *
     * arn:aws:<region>:<account>:container/<name>
     *
     * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Unix timestamp.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The name of the container.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of container creation or deletion. The status is one of the following: `CREATING`, `ACTIVE`, or `DELETING`. While the service is creating the container, the status is `CREATING`. When the endpoint is available, the status changes to `ACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.mediastore.model.ContainerStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastore.model.Container = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Container(")
        append("accessLoggingEnabled=$accessLoggingEnabled,")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("endpoint=$endpoint,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLoggingEnabled?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Container

        if (accessLoggingEnabled != other.accessLoggingEnabled) return false
        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (endpoint != other.endpoint) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastore.model.Container = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The state of access logging on the container. This value is `false` by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to `true`, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
         */
        public var accessLoggingEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the container. The ARN has the following format:
         *
         * arn:aws:<region>:<account>:container/<name>
         *
         * For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
         */
        public var arn: kotlin.String? = null
        /**
         * Unix timestamp.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The name of the container.
         */
        public var name: kotlin.String? = null
        /**
         * The status of container creation or deletion. The status is one of the following: `CREATING`, `ACTIVE`, or `DELETING`. While the service is creating the container, the status is `CREATING`. When the endpoint is available, the status changes to `ACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.mediastore.model.ContainerStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastore.model.Container) : this() {
            this.accessLoggingEnabled = x.accessLoggingEnabled
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.endpoint = x.endpoint
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastore.model.Container = Container(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
