// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mediastore.auth.DefaultMediaStoreAuthSchemeProvider
import aws.sdk.kotlin.services.mediastore.auth.MediaStoreAuthSchemeProvider
import aws.sdk.kotlin.services.mediastore.endpoints.DefaultMediaStoreEndpointProvider
import aws.sdk.kotlin.services.mediastore.endpoints.MediaStoreEndpointParameters
import aws.sdk.kotlin.services.mediastore.endpoints.MediaStoreEndpointProvider
import aws.sdk.kotlin.services.mediastore.model.CreateContainerRequest
import aws.sdk.kotlin.services.mediastore.model.CreateContainerResponse
import aws.sdk.kotlin.services.mediastore.model.DeleteContainerPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.DeleteContainerPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.DeleteContainerRequest
import aws.sdk.kotlin.services.mediastore.model.DeleteContainerResponse
import aws.sdk.kotlin.services.mediastore.model.DeleteCorsPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.DeleteCorsPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.DeleteLifecyclePolicyRequest
import aws.sdk.kotlin.services.mediastore.model.DeleteLifecyclePolicyResponse
import aws.sdk.kotlin.services.mediastore.model.DeleteMetricPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.DeleteMetricPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.DescribeContainerRequest
import aws.sdk.kotlin.services.mediastore.model.DescribeContainerResponse
import aws.sdk.kotlin.services.mediastore.model.GetContainerPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.GetContainerPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.GetCorsPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.GetCorsPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.GetLifecyclePolicyRequest
import aws.sdk.kotlin.services.mediastore.model.GetLifecyclePolicyResponse
import aws.sdk.kotlin.services.mediastore.model.GetMetricPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.GetMetricPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.ListContainersRequest
import aws.sdk.kotlin.services.mediastore.model.ListContainersResponse
import aws.sdk.kotlin.services.mediastore.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediastore.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediastore.model.PutContainerPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.PutContainerPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.PutCorsPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.PutCorsPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.PutLifecyclePolicyRequest
import aws.sdk.kotlin.services.mediastore.model.PutLifecyclePolicyResponse
import aws.sdk.kotlin.services.mediastore.model.PutMetricPolicyRequest
import aws.sdk.kotlin.services.mediastore.model.PutMetricPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.StartAccessLoggingRequest
import aws.sdk.kotlin.services.mediastore.model.StartAccessLoggingResponse
import aws.sdk.kotlin.services.mediastore.model.StopAccessLoggingRequest
import aws.sdk.kotlin.services.mediastore.model.StopAccessLoggingResponse
import aws.sdk.kotlin.services.mediastore.model.TagResourceRequest
import aws.sdk.kotlin.services.mediastore.model.TagResourceResponse
import aws.sdk.kotlin.services.mediastore.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediastore.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MediaStore"
public const val SdkVersion: String = "1.4.46"
public const val ServiceApiVersion: String = "2017-09-01"

/**
 * An AWS Elemental MediaStore container is a namespace that holds folders and objects. You use a container endpoint to create, read, and delete objects.
 */
public interface MediaStoreClient : SdkClient {
    /**
     * MediaStoreClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaStoreClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaStore",
                "MEDIASTORE",
                "mediastore",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaStoreClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaStoreClient = DefaultMediaStoreClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaStoreEndpointProvider = builder.endpointProvider ?: DefaultMediaStoreEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaStoreAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaStoreAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaStore"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaStoreEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaStoreAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.
     */
    public suspend fun createContainer(input: CreateContainerRequest): CreateContainerResponse

    /**
     * Deletes the specified container. Before you make a `DeleteContainer` request, delete any objects in the container or in any folders in the container. You can delete only empty containers.
     */
    public suspend fun deleteContainer(input: DeleteContainerRequest): DeleteContainerResponse

    /**
     * Deletes the access policy that is associated with the specified container.
     */
    public suspend fun deleteContainerPolicy(input: DeleteContainerPolicyRequest): DeleteContainerPolicyResponse

    /**
     * Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.
     *
     * To use this operation, you must have permission to perform the `MediaStore:DeleteCorsPolicy` action. The container owner has this permission by default and can grant this permission to others.
     */
    public suspend fun deleteCorsPolicy(input: DeleteCorsPolicyRequest): DeleteCorsPolicyResponse

    /**
     * Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.
     */
    public suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Deletes the metric policy that is associated with the specified container. If there is no metric policy associated with the container, MediaStore doesn't send metrics to CloudWatch.
     */
    public suspend fun deleteMetricPolicy(input: DeleteMetricPolicyRequest): DeleteMetricPolicyResponse

    /**
     * Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint does not change after it has been assigned. The `DescribeContainer` request returns a single `Container` object based on `ContainerName`. To return all `Container` objects that are associated with a specified AWS account, use ListContainers.
     */
    public suspend fun describeContainer(input: DescribeContainerRequest = DescribeContainerRequest { }): DescribeContainerResponse

    /**
     * Retrieves the access policy for the specified container. For information about the data that is included in an access policy, see the [AWS Identity and Access Management User Guide](https://aws.amazon.com/documentation/iam/).
     */
    public suspend fun getContainerPolicy(input: GetContainerPolicyRequest): GetContainerPolicyResponse

    /**
     * Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.
     *
     * To use this operation, you must have permission to perform the `MediaStore:GetCorsPolicy` action. By default, the container owner has this permission and can grant it to others.
     */
    public suspend fun getCorsPolicy(input: GetCorsPolicyRequest): GetCorsPolicyResponse

    /**
     * Retrieves the object lifecycle policy that is assigned to a container.
     */
    public suspend fun getLifecyclePolicy(input: GetLifecyclePolicyRequest): GetLifecyclePolicyResponse

    /**
     * Returns the metric policy for the specified container.
     */
    public suspend fun getMetricPolicy(input: GetMetricPolicyRequest): GetMetricPolicyResponse

    /**
     * Lists the properties of all containers in AWS Elemental MediaStore.
     *
     * You can query to receive all the containers in one response. Or you can include the `MaxResults` parameter to receive a limited number of containers in each response. In this case, the response includes a token. To get the next set of containers, send the command again, this time with the `NextToken` parameter (with the returned token as its value). The next set of responses appears, with a token if there are still more containers to receive.
     *
     * See also DescribeContainer, which gets the properties of one container.
     */
    public suspend fun listContainers(input: ListContainersRequest = ListContainersRequest { }): ListContainersResponse

    /**
     * Returns a list of the tags assigned to the specified container.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates an access policy for the specified container to restrict the users and clients that can access it. For information about the data that is included in an access policy, see the [AWS Identity and Access Management User Guide](https://aws.amazon.com/documentation/iam/).
     *
     * For this release of the REST API, you can create only one policy for a container. If you enter `PutContainerPolicy` twice, the second command modifies the existing policy.
     */
    public suspend fun putContainerPolicy(input: PutContainerPolicyRequest): PutContainerPolicyResponse

    /**
     * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
     *
     * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
     *
     * To learn more about CORS, see [Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore](https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html).
     */
    public suspend fun putCorsPolicy(input: PutCorsPolicyRequest): PutCorsPolicyResponse

    /**
     * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.
     *
     * For information about how to construct an object lifecycle policy, see [Components of an Object Lifecycle Policy](https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html).
     */
    public suspend fun putLifecyclePolicy(input: PutLifecyclePolicyRequest): PutLifecyclePolicyResponse

    /**
     * The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.
     */
    public suspend fun putMetricPolicy(input: PutMetricPolicyRequest): PutMetricPolicyResponse

    /**
     * Starts access logging on the specified container. When you enable access logging on a container, MediaStore delivers access logs for objects stored in that container to Amazon CloudWatch Logs.
     */
    public suspend fun startAccessLogging(input: StartAccessLoggingRequest): StartAccessLoggingResponse

    /**
     * Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.
     */
    public suspend fun stopAccessLogging(input: StopAccessLoggingRequest): StopAccessLoggingResponse

    /**
     * Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see [Tagging Resources in MediaStore](https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified container. You can specify one or more tags to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaStoreClient.withConfig(block: MediaStoreClient.Config.Builder.() -> Unit): MediaStoreClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaStoreClient(newConfig)
}

/**
 * Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.
 */
public suspend inline fun MediaStoreClient.createContainer(crossinline block: CreateContainerRequest.Builder.() -> Unit): CreateContainerResponse = createContainer(CreateContainerRequest.Builder().apply(block).build())

/**
 * Deletes the specified container. Before you make a `DeleteContainer` request, delete any objects in the container or in any folders in the container. You can delete only empty containers.
 */
public suspend inline fun MediaStoreClient.deleteContainer(crossinline block: DeleteContainerRequest.Builder.() -> Unit): DeleteContainerResponse = deleteContainer(DeleteContainerRequest.Builder().apply(block).build())

/**
 * Deletes the access policy that is associated with the specified container.
 */
public suspend inline fun MediaStoreClient.deleteContainerPolicy(crossinline block: DeleteContainerPolicyRequest.Builder.() -> Unit): DeleteContainerPolicyResponse = deleteContainerPolicy(DeleteContainerPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.
 *
 * To use this operation, you must have permission to perform the `MediaStore:DeleteCorsPolicy` action. The container owner has this permission by default and can grant this permission to others.
 */
public suspend inline fun MediaStoreClient.deleteCorsPolicy(crossinline block: DeleteCorsPolicyRequest.Builder.() -> Unit): DeleteCorsPolicyResponse = deleteCorsPolicy(DeleteCorsPolicyRequest.Builder().apply(block).build())

/**
 * Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.
 */
public suspend inline fun MediaStoreClient.deleteLifecyclePolicy(crossinline block: DeleteLifecyclePolicyRequest.Builder.() -> Unit): DeleteLifecyclePolicyResponse = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the metric policy that is associated with the specified container. If there is no metric policy associated with the container, MediaStore doesn't send metrics to CloudWatch.
 */
public suspend inline fun MediaStoreClient.deleteMetricPolicy(crossinline block: DeleteMetricPolicyRequest.Builder.() -> Unit): DeleteMetricPolicyResponse = deleteMetricPolicy(DeleteMetricPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint does not change after it has been assigned. The `DescribeContainer` request returns a single `Container` object based on `ContainerName`. To return all `Container` objects that are associated with a specified AWS account, use ListContainers.
 */
public suspend inline fun MediaStoreClient.describeContainer(crossinline block: DescribeContainerRequest.Builder.() -> Unit): DescribeContainerResponse = describeContainer(DescribeContainerRequest.Builder().apply(block).build())

/**
 * Retrieves the access policy for the specified container. For information about the data that is included in an access policy, see the [AWS Identity and Access Management User Guide](https://aws.amazon.com/documentation/iam/).
 */
public suspend inline fun MediaStoreClient.getContainerPolicy(crossinline block: GetContainerPolicyRequest.Builder.() -> Unit): GetContainerPolicyResponse = getContainerPolicy(GetContainerPolicyRequest.Builder().apply(block).build())

/**
 * Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.
 *
 * To use this operation, you must have permission to perform the `MediaStore:GetCorsPolicy` action. By default, the container owner has this permission and can grant it to others.
 */
public suspend inline fun MediaStoreClient.getCorsPolicy(crossinline block: GetCorsPolicyRequest.Builder.() -> Unit): GetCorsPolicyResponse = getCorsPolicy(GetCorsPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the object lifecycle policy that is assigned to a container.
 */
public suspend inline fun MediaStoreClient.getLifecyclePolicy(crossinline block: GetLifecyclePolicyRequest.Builder.() -> Unit): GetLifecyclePolicyResponse = getLifecyclePolicy(GetLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Returns the metric policy for the specified container.
 */
public suspend inline fun MediaStoreClient.getMetricPolicy(crossinline block: GetMetricPolicyRequest.Builder.() -> Unit): GetMetricPolicyResponse = getMetricPolicy(GetMetricPolicyRequest.Builder().apply(block).build())

/**
 * Lists the properties of all containers in AWS Elemental MediaStore.
 *
 * You can query to receive all the containers in one response. Or you can include the `MaxResults` parameter to receive a limited number of containers in each response. In this case, the response includes a token. To get the next set of containers, send the command again, this time with the `NextToken` parameter (with the returned token as its value). The next set of responses appears, with a token if there are still more containers to receive.
 *
 * See also DescribeContainer, which gets the properties of one container.
 */
public suspend inline fun MediaStoreClient.listContainers(crossinline block: ListContainersRequest.Builder.() -> Unit): ListContainersResponse = listContainers(ListContainersRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified container.
 */
public suspend inline fun MediaStoreClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates an access policy for the specified container to restrict the users and clients that can access it. For information about the data that is included in an access policy, see the [AWS Identity and Access Management User Guide](https://aws.amazon.com/documentation/iam/).
 *
 * For this release of the REST API, you can create only one policy for a container. If you enter `PutContainerPolicy` twice, the second command modifies the existing policy.
 */
public suspend inline fun MediaStoreClient.putContainerPolicy(crossinline block: PutContainerPolicyRequest.Builder.() -> Unit): PutContainerPolicyResponse = putContainerPolicy(PutContainerPolicyRequest.Builder().apply(block).build())

/**
 * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
 *
 * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
 *
 * To learn more about CORS, see [Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore](https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html).
 */
public suspend inline fun MediaStoreClient.putCorsPolicy(crossinline block: PutCorsPolicyRequest.Builder.() -> Unit): PutCorsPolicyResponse = putCorsPolicy(PutCorsPolicyRequest.Builder().apply(block).build())

/**
 * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.
 *
 * For information about how to construct an object lifecycle policy, see [Components of an Object Lifecycle Policy](https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html).
 */
public suspend inline fun MediaStoreClient.putLifecyclePolicy(crossinline block: PutLifecyclePolicyRequest.Builder.() -> Unit): PutLifecyclePolicyResponse = putLifecyclePolicy(PutLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.
 */
public suspend inline fun MediaStoreClient.putMetricPolicy(crossinline block: PutMetricPolicyRequest.Builder.() -> Unit): PutMetricPolicyResponse = putMetricPolicy(PutMetricPolicyRequest.Builder().apply(block).build())

/**
 * Starts access logging on the specified container. When you enable access logging on a container, MediaStore delivers access logs for objects stored in that container to Amazon CloudWatch Logs.
 */
public suspend inline fun MediaStoreClient.startAccessLogging(crossinline block: StartAccessLoggingRequest.Builder.() -> Unit): StartAccessLoggingResponse = startAccessLogging(StartAccessLoggingRequest.Builder().apply(block).build())

/**
 * Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.
 */
public suspend inline fun MediaStoreClient.stopAccessLogging(crossinline block: StopAccessLoggingRequest.Builder.() -> Unit): StopAccessLoggingResponse = stopAccessLogging(StopAccessLoggingRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see [Tagging Resources in MediaStore](https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
 */
public suspend inline fun MediaStoreClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified container. You can specify one or more tags to remove.
 */
public suspend inline fun MediaStoreClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
