// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.serde

import aws.sdk.kotlin.services.mediastore.model.CorsRule
import aws.sdk.kotlin.services.mediastore.model.GetCorsPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.MediaStoreException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetCorsPolicyOperationDeserializer: HttpDeserialize<GetCorsPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetCorsPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCorsPolicyError(context, call)
        }
        val builder = GetCorsPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCorsPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetCorsPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaStoreException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ContainerInUseException" -> ContainerInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "ContainerNotFoundException" -> ContainerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "CorsPolicyNotFoundException" -> CorsPolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> MediaStoreException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCorsPolicyOperationBody(builder: GetCorsPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CORSPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CorsPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CORSPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CORSPOLICY_DESCRIPTOR.index -> builder.corsPolicy =
                    deserializer.deserializeList(CORSPOLICY_DESCRIPTOR) {
                        val col0 = mutableListOf<CorsRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCorsRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
