// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.serde

import aws.sdk.kotlin.services.mediastore.model.DeleteContainerPolicyResponse
import aws.sdk.kotlin.services.mediastore.model.MediaStoreException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteContainerPolicyOperationDeserializer: HttpDeserialize<DeleteContainerPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteContainerPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteContainerPolicyError(context, call)
        }
        val builder = DeleteContainerPolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteContainerPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaStoreException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ContainerInUseException" -> ContainerInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "ContainerNotFoundException" -> ContainerNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "PolicyNotFoundException" -> PolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaStoreException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
