// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediastore.model



/**
 * A rule for a CORS policy. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
 */
public class CorsRule private constructor(builder: Builder) {
    /**
     * Specifies which headers are allowed in a preflight `OPTIONS` request through the `Access-Control-Request-Headers` header. Each header name that is specified in `Access-Control-Request-Headers` must have a corresponding entry in the rule. Only the headers that were requested are sent back.
     *
     * This element can contain only one wildcard character (*).
     */
    public val allowedHeaders: List<String> = requireNotNull(builder.allowedHeaders) { "A non-null value must be provided for allowedHeaders" }
    /**
     * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
     *
     * Each CORS rule must contain at least one `AllowedMethods` and one `AllowedOrigins` element.
     */
    public val allowedMethods: List<MethodName>? = builder.allowedMethods
    /**
     * One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     *
     * Each CORS rule must have at least one `AllowedOrigins` element. The string value can include only one wildcard character (*), for example, http:/&#47;*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.
     */
    public val allowedOrigins: List<String> = requireNotNull(builder.allowedOrigins) { "A non-null value must be provided for allowedOrigins" }
    /**
     * One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     *
     * This element is optional for each rule.
     */
    public val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * The time in seconds that your browser caches the preflight response for the specified resource.
     *
     * A CORS rule can have only one `MaxAgeSeconds` element.
     */
    public val maxAgeSeconds: kotlin.Int = builder.maxAgeSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediastore.model.CorsRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CorsRule(")
        append("allowedHeaders=$allowedHeaders,")
        append("allowedMethods=$allowedMethods,")
        append("allowedOrigins=$allowedOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("maxAgeSeconds=$maxAgeSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedHeaders.hashCode()
        result = 31 * result + (allowedMethods?.hashCode() ?: 0)
        result = 31 * result + (allowedOrigins.hashCode())
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (maxAgeSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CorsRule

        if (allowedHeaders != other.allowedHeaders) return false
        if (allowedMethods != other.allowedMethods) return false
        if (allowedOrigins != other.allowedOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (maxAgeSeconds != other.maxAgeSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediastore.model.CorsRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies which headers are allowed in a preflight `OPTIONS` request through the `Access-Control-Request-Headers` header. Each header name that is specified in `Access-Control-Request-Headers` must have a corresponding entry in the rule. Only the headers that were requested are sent back.
         *
         * This element can contain only one wildcard character (*).
         */
        public var allowedHeaders: List<String>? = null
        /**
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         *
         * Each CORS rule must contain at least one `AllowedMethods` and one `AllowedOrigins` element.
         */
        public var allowedMethods: List<MethodName>? = null
        /**
         * One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
         *
         * Each CORS rule must have at least one `AllowedOrigins` element. The string value can include only one wildcard character (*), for example, http:/&#47;*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.
         */
        public var allowedOrigins: List<String>? = null
        /**
         * One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
         *
         * This element is optional for each rule.
         */
        public var exposeHeaders: List<String>? = null
        /**
         * The time in seconds that your browser caches the preflight response for the specified resource.
         *
         * A CORS rule can have only one `MaxAgeSeconds` element.
         */
        public var maxAgeSeconds: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediastore.model.CorsRule) : this() {
            this.allowedHeaders = x.allowedHeaders
            this.allowedMethods = x.allowedMethods
            this.allowedOrigins = x.allowedOrigins
            this.exposeHeaders = x.exposeHeaders
            this.maxAgeSeconds = x.maxAgeSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediastore.model.CorsRule = CorsRule(this)

        internal fun correctErrors(): Builder {
            if (allowedHeaders == null) allowedHeaders = emptyList()
            if (allowedOrigins == null) allowedOrigins = emptyList()
            return this
        }
    }
}
