// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.serde

import aws.sdk.kotlin.services.mediapackagevod.model.DescribeAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.EgressEndpoint
import aws.sdk.kotlin.services.mediapackagevod.model.MediaPackageVodException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeAssetOperationDeserializer: HttpDeserialize<DescribeAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAssetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetError(context, call)
        }
        val builder = DescribeAssetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAssetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeAssetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageVodException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaPackageVodException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetOperationBody(builder: DescribeAssetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdAt"))
    val EGRESSENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("egressEndpoints"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val PACKAGINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packagingGroupId"))
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceId"))
    val SOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceArn"))
    val SOURCEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceRoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(EGRESSENDPOINTS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(PACKAGINGGROUPID_DESCRIPTOR)
        field(RESOURCEID_DESCRIPTOR)
        field(SOURCEARN_DESCRIPTOR)
        field(SOURCEROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString()
                EGRESSENDPOINTS_DESCRIPTOR.index -> builder.egressEndpoints =
                    deserializer.deserializeList(EGRESSENDPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<EgressEndpoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEgressEndpointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                PACKAGINGGROUPID_DESCRIPTOR.index -> builder.packagingGroupId = deserializeString()
                RESOURCEID_DESCRIPTOR.index -> builder.resourceId = deserializeString()
                SOURCEARN_DESCRIPTOR.index -> builder.sourceArn = deserializeString()
                SOURCEROLEARN_DESCRIPTOR.index -> builder.sourceRoleArn = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
