// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.serde

import aws.sdk.kotlin.services.mediapackagevod.model.CmafPackage
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DashPackage
import aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage
import aws.sdk.kotlin.services.mediapackagevod.model.MediaPackageVodException
import aws.sdk.kotlin.services.mediapackagevod.model.MssPackage
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreatePackagingConfigurationOperationDeserializer: HttpDeserialize<CreatePackagingConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreatePackagingConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePackagingConfigurationError(context, call)
        }
        val builder = CreatePackagingConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePackagingConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreatePackagingConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageVodException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaPackageVodException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePackagingConfigurationOperationBody(builder: CreatePackagingConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CMAFPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cmafPackage"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdAt"))
    val DASHPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dashPackage"))
    val HLSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsPackage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MSSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mssPackage"))
    val PACKAGINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packagingGroupId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CMAFPACKAGE_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DASHPACKAGE_DESCRIPTOR)
        field(HLSPACKAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MSSPACKAGE_DESCRIPTOR)
        field(PACKAGINGGROUPID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CMAFPACKAGE_DESCRIPTOR.index -> builder.cmafPackage = deserializeCmafPackageDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString()
                DASHPACKAGE_DESCRIPTOR.index -> builder.dashPackage = deserializeDashPackageDocument(deserializer)
                HLSPACKAGE_DESCRIPTOR.index -> builder.hlsPackage = deserializeHlsPackageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MSSPACKAGE_DESCRIPTOR.index -> builder.mssPackage = deserializeMssPackageDocument(deserializer)
                PACKAGINGGROUPID_DESCRIPTOR.index -> builder.packagingGroupId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
