// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.paginators

import aws.sdk.kotlin.services.mediapackagevod.MediaPackageVodClient
import aws.sdk.kotlin.services.mediapackagevod.model.AssetShallow
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.PackagingConfiguration
import aws.sdk.kotlin.services.mediapackagevod.model.PackagingGroup
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetsResponse]
 */
public fun MediaPackageVodClient.listAssetsPaginated(initialRequest: ListAssetsRequest = ListAssetsRequest { }): Flow<ListAssetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssetsPaginated.listAssets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetsResponse]
 */
public fun MediaPackageVodClient.listAssetsPaginated(block: ListAssetsRequest.Builder.() -> Unit): Flow<ListAssetsResponse> =
    listAssetsPaginated(ListAssetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssetsPaginated]
 * to access the nested member [AssetShallow]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetShallow]
 */
@JvmName("listAssetsResponseAssetShallow")
public fun Flow<ListAssetsResponse>.assets(): Flow<AssetShallow> =
    transform() { response ->
        response.assets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackagingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagingConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagingConfigurationsResponse]
 */
public fun MediaPackageVodClient.listPackagingConfigurationsPaginated(initialRequest: ListPackagingConfigurationsRequest = ListPackagingConfigurationsRequest { }): Flow<ListPackagingConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagingConfigurationsPaginated.listPackagingConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagingConfigurationsResponse]
 */
public fun MediaPackageVodClient.listPackagingConfigurationsPaginated(block: ListPackagingConfigurationsRequest.Builder.() -> Unit): Flow<ListPackagingConfigurationsResponse> =
    listPackagingConfigurationsPaginated(ListPackagingConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackagingConfigurationsPaginated]
 * to access the nested member [PackagingConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackagingConfiguration]
 */
@JvmName("listPackagingConfigurationsResponsePackagingConfiguration")
public fun Flow<ListPackagingConfigurationsResponse>.packagingConfigurations(): Flow<PackagingConfiguration> =
    transform() { response ->
        response.packagingConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackagingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagingGroupsResponse]
 */
public fun MediaPackageVodClient.listPackagingGroupsPaginated(initialRequest: ListPackagingGroupsRequest = ListPackagingGroupsRequest { }): Flow<ListPackagingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagingGroupsPaginated.listPackagingGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagingGroupsResponse]
 */
public fun MediaPackageVodClient.listPackagingGroupsPaginated(block: ListPackagingGroupsRequest.Builder.() -> Unit): Flow<ListPackagingGroupsResponse> =
    listPackagingGroupsPaginated(ListPackagingGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackagingGroupsPaginated]
 * to access the nested member [PackagingGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackagingGroup]
 */
@JvmName("listPackagingGroupsResponsePackagingGroup")
public fun Flow<ListPackagingGroupsResponse>.packagingGroups(): Flow<PackagingGroup> =
    transform() { response ->
        response.packagingGroups?.forEach {
            emit(it)
        }
    }
