// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.model



/**
 * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
 */
public class SpekeKeyProvider private constructor(builder: Builder) {
    /**
     * Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use. Note the following considerations when using encryptionContractConfiguration: encryptionContractConfiguration can be used for DASH endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification. You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
     */
    public val encryptionContractConfiguration: aws.sdk.kotlin.services.mediapackagevod.model.EncryptionContractConfiguration? = builder.encryptionContractConfiguration
    /**
     * An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The system IDs to include in key requests.
     */
    public val systemIds: List<String>? = builder.systemIds
    /**
     * The URL of the external key provider service.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagevod.model.SpekeKeyProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpekeKeyProvider(")
        append("encryptionContractConfiguration=$encryptionContractConfiguration,")
        append("roleArn=$roleArn,")
        append("systemIds=$systemIds,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionContractConfiguration?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (systemIds?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpekeKeyProvider

        if (encryptionContractConfiguration != other.encryptionContractConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (systemIds != other.systemIds) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagevod.model.SpekeKeyProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use encryptionContractConfiguration to configure one or more content encryption keys for your endpoints that use SPEKE 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use. Note the following considerations when using encryptionContractConfiguration: encryptionContractConfiguration can be used for DASH endpoints that use SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification. You must disable key rotation for this endpoint by setting keyRotationIntervalSeconds to 0.
         */
        public var encryptionContractConfiguration: aws.sdk.kotlin.services.mediapackagevod.model.EncryptionContractConfiguration? = null
        /**
         * An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The system IDs to include in key requests.
         */
        public var systemIds: List<String>? = null
        /**
         * The URL of the external key provider service.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagevod.model.SpekeKeyProvider) : this() {
            this.encryptionContractConfiguration = x.encryptionContractConfiguration
            this.roleArn = x.roleArn
            this.systemIds = x.systemIds
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagevod.model.SpekeKeyProvider = SpekeKeyProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagevod.model.EncryptionContractConfiguration] inside the given [block]
         */
        public fun encryptionContractConfiguration(block: aws.sdk.kotlin.services.mediapackagevod.model.EncryptionContractConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionContractConfiguration = aws.sdk.kotlin.services.mediapackagevod.model.EncryptionContractConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
