// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.model



/**
 * An HTTP Live Streaming (HLS) manifest configuration.
 */
public class HlsManifest private constructor(builder: Builder) {
    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     */
    public val adMarkers: aws.sdk.kotlin.services.mediapackagevod.model.AdMarkers? = builder.adMarkers
    /**
     * When enabled, an I-Frame only stream will be included in the output.
     */
    public val includeIframeOnlyStream: kotlin.Boolean? = builder.includeIframeOnlyStream
    /**
     * An optional string to include in the name of the manifest.
     */
    public val manifestName: kotlin.String? = builder.manifestName
    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     */
    public val programDateTimeIntervalSeconds: kotlin.Int? = builder.programDateTimeIntervalSeconds
    /**
     * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     */
    public val repeatExtXKey: kotlin.Boolean? = builder.repeatExtXKey
    /**
     * A StreamSelection configuration.
     */
    public val streamSelection: aws.sdk.kotlin.services.mediapackagevod.model.StreamSelection? = builder.streamSelection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagevod.model.HlsManifest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsManifest(")
        append("adMarkers=$adMarkers,")
        append("includeIframeOnlyStream=$includeIframeOnlyStream,")
        append("manifestName=$manifestName,")
        append("programDateTimeIntervalSeconds=$programDateTimeIntervalSeconds,")
        append("repeatExtXKey=$repeatExtXKey,")
        append("streamSelection=$streamSelection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (includeIframeOnlyStream?.hashCode() ?: 0)
        result = 31 * result + (manifestName?.hashCode() ?: 0)
        result = 31 * result + (programDateTimeIntervalSeconds ?: 0)
        result = 31 * result + (repeatExtXKey?.hashCode() ?: 0)
        result = 31 * result + (streamSelection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsManifest

        if (adMarkers != other.adMarkers) return false
        if (includeIframeOnlyStream != other.includeIframeOnlyStream) return false
        if (manifestName != other.manifestName) return false
        if (programDateTimeIntervalSeconds != other.programDateTimeIntervalSeconds) return false
        if (repeatExtXKey != other.repeatExtXKey) return false
        if (streamSelection != other.streamSelection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagevod.model.HlsManifest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         */
        public var adMarkers: aws.sdk.kotlin.services.mediapackagevod.model.AdMarkers? = null
        /**
         * When enabled, an I-Frame only stream will be included in the output.
         */
        public var includeIframeOnlyStream: kotlin.Boolean? = null
        /**
         * An optional string to include in the name of the manifest.
         */
        public var manifestName: kotlin.String? = null
        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
         */
        public var programDateTimeIntervalSeconds: kotlin.Int? = null
        /**
         * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         */
        public var repeatExtXKey: kotlin.Boolean? = null
        /**
         * A StreamSelection configuration.
         */
        public var streamSelection: aws.sdk.kotlin.services.mediapackagevod.model.StreamSelection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagevod.model.HlsManifest) : this() {
            this.adMarkers = x.adMarkers
            this.includeIframeOnlyStream = x.includeIframeOnlyStream
            this.manifestName = x.manifestName
            this.programDateTimeIntervalSeconds = x.programDateTimeIntervalSeconds
            this.repeatExtXKey = x.repeatExtXKey
            this.streamSelection = x.streamSelection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagevod.model.HlsManifest = HlsManifest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagevod.model.StreamSelection] inside the given [block]
         */
        public fun streamSelection(block: aws.sdk.kotlin.services.mediapackagevod.model.StreamSelection.Builder.() -> kotlin.Unit) {
            this.streamSelection = aws.sdk.kotlin.services.mediapackagevod.model.StreamSelection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
