// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mediapackagevod.auth.DefaultMediaPackageVodAuthSchemeProvider
import aws.sdk.kotlin.services.mediapackagevod.auth.MediaPackageVodAuthSchemeProvider
import aws.sdk.kotlin.services.mediapackagevod.endpoints.DefaultMediaPackageVodEndpointProvider
import aws.sdk.kotlin.services.mediapackagevod.endpoints.MediaPackageVodEndpointParameters
import aws.sdk.kotlin.services.mediapackagevod.endpoints.MediaPackageVodEndpointProvider
import aws.sdk.kotlin.services.mediapackagevod.model.ConfigureLogsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ConfigureLogsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreateAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreateAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeleteAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeleteAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribeAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribeAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.TagResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.TagResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.UpdatePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.UpdatePackagingGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MediaPackage Vod"
public const val SdkVersion: String = "1.0.78"
public const val ServiceApiVersion: String = "2018-11-07"

/**
 * AWS Elemental MediaPackage VOD
 */
public interface MediaPackageVodClient : SdkClient {
    /**
     * MediaPackageVodClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaPackageVodClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaPackageVod",
                "MEDIAPACKAGE_VOD",
                "mediapackage_vod",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaPackageVodClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaPackageVodClient = DefaultMediaPackageVodClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaPackageVodEndpointProvider = builder.endpointProvider ?: DefaultMediaPackageVodEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaPackageVodAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaPackageVodAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaPackage Vod"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaPackageVodEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaPackageVodAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Changes the packaging group's properities to configure log subscription
     */
    public suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse

    /**
     * Creates a new MediaPackage VOD Asset resource.
     */
    public suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse

    /**
     * Creates a new MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun createPackagingConfiguration(input: CreatePackagingConfigurationRequest): CreatePackagingConfigurationResponse

    /**
     * Creates a new MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun createPackagingGroup(input: CreatePackagingGroupRequest): CreatePackagingGroupResponse

    /**
     * Deletes an existing MediaPackage VOD Asset resource.
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * Deletes a MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun deletePackagingConfiguration(input: DeletePackagingConfigurationRequest): DeletePackagingConfigurationResponse

    /**
     * Deletes a MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun deletePackagingGroup(input: DeletePackagingGroupRequest): DeletePackagingGroupResponse

    /**
     * Returns a description of a MediaPackage VOD Asset resource.
     */
    public suspend fun describeAsset(input: DescribeAssetRequest): DescribeAssetResponse

    /**
     * Returns a description of a MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun describePackagingConfiguration(input: DescribePackagingConfigurationRequest): DescribePackagingConfigurationResponse

    /**
     * Returns a description of a MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun describePackagingGroup(input: DescribePackagingGroupRequest): DescribePackagingGroupResponse

    /**
     * Returns a collection of MediaPackage VOD Asset resources.
     */
    public suspend fun listAssets(input: ListAssetsRequest = ListAssetsRequest { }): ListAssetsResponse

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.
     */
    public suspend fun listPackagingConfigurations(input: ListPackagingConfigurationsRequest = ListPackagingConfigurationsRequest { }): ListPackagingConfigurationsResponse

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.
     */
    public suspend fun listPackagingGroups(input: ListPackagingGroupsRequest = ListPackagingGroupsRequest { }): ListPackagingGroupsResponse

    /**
     * Returns a list of the tags assigned to the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds tags to the specified resource. You can specify one or more tags to add.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource. You can specify one or more tags to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
     */
    public suspend fun updatePackagingGroup(input: UpdatePackagingGroupRequest): UpdatePackagingGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaPackageVodClient.withConfig(block: MediaPackageVodClient.Config.Builder.() -> Unit): MediaPackageVodClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaPackageVodClient(newConfig)
}

/**
 * Changes the packaging group's properities to configure log subscription
 */
public suspend inline fun MediaPackageVodClient.configureLogs(crossinline block: ConfigureLogsRequest.Builder.() -> Unit): ConfigureLogsResponse = configureLogs(ConfigureLogsRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.createAsset(crossinline block: CreateAssetRequest.Builder.() -> Unit): CreateAssetResponse = createAsset(CreateAssetRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.createPackagingConfiguration(crossinline block: CreatePackagingConfigurationRequest.Builder.() -> Unit): CreatePackagingConfigurationResponse = createPackagingConfiguration(CreatePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.createPackagingGroup(crossinline block: CreatePackagingGroupRequest.Builder.() -> Unit): CreatePackagingGroupResponse = createPackagingGroup(CreatePackagingGroupRequest.Builder().apply(block).build())

/**
 * Deletes an existing MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * Deletes a MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.deletePackagingConfiguration(crossinline block: DeletePackagingConfigurationRequest.Builder.() -> Unit): DeletePackagingConfigurationResponse = deletePackagingConfiguration(DeletePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.deletePackagingGroup(crossinline block: DeletePackagingGroupRequest.Builder.() -> Unit): DeletePackagingGroupResponse = deletePackagingGroup(DeletePackagingGroupRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.describeAsset(crossinline block: DescribeAssetRequest.Builder.() -> Unit): DescribeAssetResponse = describeAsset(DescribeAssetRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.describePackagingConfiguration(crossinline block: DescribePackagingConfigurationRequest.Builder.() -> Unit): DescribePackagingConfigurationResponse = describePackagingConfiguration(DescribePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.describePackagingGroup(crossinline block: DescribePackagingGroupRequest.Builder.() -> Unit): DescribePackagingGroupResponse = describePackagingGroup(DescribePackagingGroupRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD Asset resources.
 */
public suspend inline fun MediaPackageVodClient.listAssets(crossinline block: ListAssetsRequest.Builder.() -> Unit): ListAssetsResponse = listAssets(ListAssetsRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD PackagingConfiguration resources.
 */
public suspend inline fun MediaPackageVodClient.listPackagingConfigurations(crossinline block: ListPackagingConfigurationsRequest.Builder.() -> Unit): ListPackagingConfigurationsResponse = listPackagingConfigurations(ListPackagingConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD PackagingGroup resources.
 */
public suspend inline fun MediaPackageVodClient.listPackagingGroups(crossinline block: ListPackagingGroupsRequest.Builder.() -> Unit): ListPackagingGroupsResponse = listPackagingGroups(ListPackagingGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified resource.
 */
public suspend inline fun MediaPackageVodClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified resource. You can specify one or more tags to add.
 */
public suspend inline fun MediaPackageVodClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource. You can specify one or more tags to remove.
 */
public suspend inline fun MediaPackageVodClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
 */
public suspend inline fun MediaPackageVodClient.updatePackagingGroup(crossinline block: UpdatePackagingGroupRequest.Builder.() -> Unit): UpdatePackagingGroupResponse = updatePackagingGroup(UpdatePackagingGroupRequest.Builder().apply(block).build())
