// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediapackagevod.model.Authorization
import aws.sdk.kotlin.services.mediapackagevod.model.EgressAccessLogs
import aws.sdk.kotlin.services.mediapackagevod.model.MediaPackageVodException
import aws.sdk.kotlin.services.mediapackagevod.model.UpdatePackagingGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class UpdatePackagingGroupOperationDeserializer: HttpDeserialize<UpdatePackagingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePackagingGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePackagingGroupError(context, response)
        }
        val builder = UpdatePackagingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdatePackagingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdatePackagingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageVodException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageVodException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePackagingGroupOperationBody(builder: UpdatePackagingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROXIMATEASSETCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("approximateAssetCount"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorization"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainName"))
    val EGRESSACCESSLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("egressAccessLogs"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROXIMATEASSETCOUNT_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(AUTHORIZATION_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(EGRESSACCESSLOGS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROXIMATEASSETCOUNT_DESCRIPTOR.index -> builder.approximateAssetCount = deserializeInt()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHORIZATION_DESCRIPTOR.index -> builder.authorization = deserializeAuthorizationDocument(deserializer)
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                EGRESSACCESSLOGS_DESCRIPTOR.index -> builder.egressAccessLogs = deserializeEgressAccessLogsDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
