// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediapackagevod.model.CmafPackage
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DashPackage
import aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage
import aws.sdk.kotlin.services.mediapackagevod.model.MediaPackageVodException
import aws.sdk.kotlin.services.mediapackagevod.model.MssPackage
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreatePackagingConfigurationOperationDeserializer: HttpDeserialize<CreatePackagingConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePackagingConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwCreatePackagingConfigurationError(context, response)
        }
        val builder = CreatePackagingConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePackagingConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePackagingConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageVodException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageVodException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePackagingConfigurationOperationBody(builder: CreatePackagingConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CMAFPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cmafPackage"))
    val DASHPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dashPackage"))
    val HLSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsPackage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MSSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mssPackage"))
    val PACKAGINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packagingGroupId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CMAFPACKAGE_DESCRIPTOR)
        field(DASHPACKAGE_DESCRIPTOR)
        field(HLSPACKAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MSSPACKAGE_DESCRIPTOR)
        field(PACKAGINGGROUPID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CMAFPACKAGE_DESCRIPTOR.index -> builder.cmafPackage = deserializeCmafPackageDocument(deserializer)
                DASHPACKAGE_DESCRIPTOR.index -> builder.dashPackage = deserializeDashPackageDocument(deserializer)
                HLSPACKAGE_DESCRIPTOR.index -> builder.hlsPackage = deserializeHlsPackageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MSSPACKAGE_DESCRIPTOR.index -> builder.mssPackage = deserializeMssPackageDocument(deserializer)
                PACKAGINGGROUPID_DESCRIPTOR.index -> builder.packagingGroupId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
