// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod.model



/**
 * An HTTP Live Streaming (HLS) packaging configuration.
 */
public class HlsPackage private constructor(builder: Builder) {
    /**
     * An HTTP Live Streaming (HLS) encryption configuration.
     */
    public val encryption: aws.sdk.kotlin.services.mediapackagevod.model.HlsEncryption? = builder.encryption
    /**
     * A list of HLS manifest configurations.
     */
    public val hlsManifests: List<HlsManifest>? = builder.hlsManifests
    /**
     * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
     */
    public val includeDvbSubtitles: kotlin.Boolean = builder.includeDvbSubtitles
    /**
     * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
     */
    public val segmentDurationSeconds: kotlin.Int = builder.segmentDurationSeconds
    /**
     * When enabled, audio streams will be placed in rendition groups in the output.
     */
    public val useAudioRenditionGroup: kotlin.Boolean = builder.useAudioRenditionGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsPackage(")
        append("encryption=$encryption,")
        append("hlsManifests=$hlsManifests,")
        append("includeDvbSubtitles=$includeDvbSubtitles,")
        append("segmentDurationSeconds=$segmentDurationSeconds,")
        append("useAudioRenditionGroup=$useAudioRenditionGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryption?.hashCode() ?: 0
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (includeDvbSubtitles.hashCode())
        result = 31 * result + (segmentDurationSeconds)
        result = 31 * result + (useAudioRenditionGroup.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsPackage

        if (encryption != other.encryption) return false
        if (hlsManifests != other.hlsManifests) return false
        if (includeDvbSubtitles != other.includeDvbSubtitles) return false
        if (segmentDurationSeconds != other.segmentDurationSeconds) return false
        if (useAudioRenditionGroup != other.useAudioRenditionGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An HTTP Live Streaming (HLS) encryption configuration.
         */
        public var encryption: aws.sdk.kotlin.services.mediapackagevod.model.HlsEncryption? = null
        /**
         * A list of HLS manifest configurations.
         */
        public var hlsManifests: List<HlsManifest>? = null
        /**
         * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
         */
        public var includeDvbSubtitles: kotlin.Boolean = false
        /**
         * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
         */
        public var segmentDurationSeconds: kotlin.Int = 0
        /**
         * When enabled, audio streams will be placed in rendition groups in the output.
         */
        public var useAudioRenditionGroup: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage) : this() {
            this.encryption = x.encryption
            this.hlsManifests = x.hlsManifests
            this.includeDvbSubtitles = x.includeDvbSubtitles
            this.segmentDurationSeconds = x.segmentDurationSeconds
            this.useAudioRenditionGroup = x.useAudioRenditionGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagevod.model.HlsPackage = HlsPackage(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagevod.model.HlsEncryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediapackagevod.model.HlsEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediapackagevod.model.HlsEncryption.invoke(block)
        }
    }
}
