// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagevod

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediapackagevod.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.mediapackagevod.endpoints.EndpointProvider
import aws.sdk.kotlin.services.mediapackagevod.model.*
import aws.sdk.kotlin.services.mediapackagevod.model.ConfigureLogsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ConfigureLogsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreateAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreateAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.CreatePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeleteAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeleteAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DeletePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribeAssetRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribeAssetResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingConfigurationRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingConfigurationResponse
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.DescribePackagingGroupResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListAssetsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingConfigurationsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListPackagingGroupsResponse
import aws.sdk.kotlin.services.mediapackagevod.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.TagResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.TagResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediapackagevod.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediapackagevod.model.UpdatePackagingGroupRequest
import aws.sdk.kotlin.services.mediapackagevod.model.UpdatePackagingGroupResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * AWS Elemental MediaPackage VOD
 */
public interface MediaPackageVodClient : SdkClient {

    override val serviceName: String
        get() = "MediaPackage Vod"
    /**
     * MediaPackageVodClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MediaPackageVodClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaPackageVodClient(config)
        }

        public operator fun invoke(config: Config): MediaPackageVodClient = DefaultMediaPackageVodClient(config)

        /**
         * Construct a [MediaPackageVodClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaPackageVodClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMediaPackageVodClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "MediaPackage Vod")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Changes the packaging group's properities to configure log subscription
     */
    public suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse

    /**
     * Creates a new MediaPackage VOD Asset resource.
     */
    public suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse

    /**
     * Creates a new MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun createPackagingConfiguration(input: CreatePackagingConfigurationRequest): CreatePackagingConfigurationResponse

    /**
     * Creates a new MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun createPackagingGroup(input: CreatePackagingGroupRequest): CreatePackagingGroupResponse

    /**
     * Deletes an existing MediaPackage VOD Asset resource.
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * Deletes a MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun deletePackagingConfiguration(input: DeletePackagingConfigurationRequest): DeletePackagingConfigurationResponse

    /**
     * Deletes a MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun deletePackagingGroup(input: DeletePackagingGroupRequest): DeletePackagingGroupResponse

    /**
     * Returns a description of a MediaPackage VOD Asset resource.
     */
    public suspend fun describeAsset(input: DescribeAssetRequest): DescribeAssetResponse

    /**
     * Returns a description of a MediaPackage VOD PackagingConfiguration resource.
     */
    public suspend fun describePackagingConfiguration(input: DescribePackagingConfigurationRequest): DescribePackagingConfigurationResponse

    /**
     * Returns a description of a MediaPackage VOD PackagingGroup resource.
     */
    public suspend fun describePackagingGroup(input: DescribePackagingGroupRequest): DescribePackagingGroupResponse

    /**
     * Returns a collection of MediaPackage VOD Asset resources.
     */
    public suspend fun listAssets(input: ListAssetsRequest = ListAssetsRequest {}): ListAssetsResponse

    /**
     * Returns a collection of MediaPackage VOD PackagingConfiguration resources.
     */
    public suspend fun listPackagingConfigurations(input: ListPackagingConfigurationsRequest = ListPackagingConfigurationsRequest {}): ListPackagingConfigurationsResponse

    /**
     * Returns a collection of MediaPackage VOD PackagingGroup resources.
     */
    public suspend fun listPackagingGroups(input: ListPackagingGroupsRequest = ListPackagingGroupsRequest {}): ListPackagingGroupsResponse

    /**
     * Returns a list of the tags assigned to the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds tags to the specified resource. You can specify one or more tags to add.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource. You can specify one or more tags to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
     */
    public suspend fun updatePackagingGroup(input: UpdatePackagingGroupRequest): UpdatePackagingGroupResponse
}

/**
 * Changes the packaging group's properities to configure log subscription
 */
public suspend inline fun MediaPackageVodClient.configureLogs(crossinline block: ConfigureLogsRequest.Builder.() -> Unit): ConfigureLogsResponse = configureLogs(ConfigureLogsRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.createAsset(crossinline block: CreateAssetRequest.Builder.() -> Unit): CreateAssetResponse = createAsset(CreateAssetRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.createPackagingConfiguration(crossinline block: CreatePackagingConfigurationRequest.Builder.() -> Unit): CreatePackagingConfigurationResponse = createPackagingConfiguration(CreatePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.createPackagingGroup(crossinline block: CreatePackagingGroupRequest.Builder.() -> Unit): CreatePackagingGroupResponse = createPackagingGroup(CreatePackagingGroupRequest.Builder().apply(block).build())

/**
 * Deletes an existing MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * Deletes a MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.deletePackagingConfiguration(crossinline block: DeletePackagingConfigurationRequest.Builder.() -> Unit): DeletePackagingConfigurationResponse = deletePackagingConfiguration(DeletePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.deletePackagingGroup(crossinline block: DeletePackagingGroupRequest.Builder.() -> Unit): DeletePackagingGroupResponse = deletePackagingGroup(DeletePackagingGroupRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD Asset resource.
 */
public suspend inline fun MediaPackageVodClient.describeAsset(crossinline block: DescribeAssetRequest.Builder.() -> Unit): DescribeAssetResponse = describeAsset(DescribeAssetRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD PackagingConfiguration resource.
 */
public suspend inline fun MediaPackageVodClient.describePackagingConfiguration(crossinline block: DescribePackagingConfigurationRequest.Builder.() -> Unit): DescribePackagingConfigurationResponse = describePackagingConfiguration(DescribePackagingConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of a MediaPackage VOD PackagingGroup resource.
 */
public suspend inline fun MediaPackageVodClient.describePackagingGroup(crossinline block: DescribePackagingGroupRequest.Builder.() -> Unit): DescribePackagingGroupResponse = describePackagingGroup(DescribePackagingGroupRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD Asset resources.
 */
public suspend inline fun MediaPackageVodClient.listAssets(crossinline block: ListAssetsRequest.Builder.() -> Unit): ListAssetsResponse = listAssets(ListAssetsRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD PackagingConfiguration resources.
 */
public suspend inline fun MediaPackageVodClient.listPackagingConfigurations(crossinline block: ListPackagingConfigurationsRequest.Builder.() -> Unit): ListPackagingConfigurationsResponse = listPackagingConfigurations(ListPackagingConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a collection of MediaPackage VOD PackagingGroup resources.
 */
public suspend inline fun MediaPackageVodClient.listPackagingGroups(crossinline block: ListPackagingGroupsRequest.Builder.() -> Unit): ListPackagingGroupsResponse = listPackagingGroups(ListPackagingGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified resource.
 */
public suspend inline fun MediaPackageVodClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified resource. You can specify one or more tags to add.
 */
public suspend inline fun MediaPackageVodClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource. You can specify one or more tags to remove.
 */
public suspend inline fun MediaPackageVodClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.
 */
public suspend inline fun MediaPackageVodClient.updatePackagingGroup(crossinline block: UpdatePackagingGroupRequest.Builder.() -> Unit): UpdatePackagingGroupResponse = updatePackagingGroup(UpdatePackagingGroupRequest.Builder().apply(block).build())
