// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.transform

import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.MediaPackageV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetChannelPolicyOperationDeserializer: HttpDeserialize<GetChannelPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetChannelPolicyResponse {
        if (!response.status.isSuccess()) {
            throwGetChannelPolicyError(context, response)
        }
        val builder = GetChannelPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetChannelPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetChannelPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetChannelPolicyOperationBody(builder: GetChannelPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelGroupName"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Policy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELGROUPNAME_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELGROUPNAME_DESCRIPTOR.index -> builder.channelGroupName = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
