// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateOriginEndpointResponse private constructor(builder: Builder) {
    /**
     * The ARN associated with the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String? = builder.channelGroupName
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * The type of container attached to this origin endpoint.
     */
    public val containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = builder.containerType
    /**
     * The date and time the origin endpoint was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the origin endpoint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An HTTP live streaming (HLS) manifest configuration.
     */
    public val hlsManifests: List<GetHlsManifestConfiguration>? = builder.hlsManifests
    /**
     * A low-latency HLS manifest configuration.
     */
    public val lowLatencyHlsManifests: List<GetLowLatencyHlsManifestConfiguration>? = builder.lowLatencyHlsManifests
    /**
     * The date and time the origin endpoint was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
     */
    public val originEndpointName: kotlin.String? = builder.originEndpointName
    /**
     * The segment configuration, including the segment name, duration, and other configuration values.
     */
    public val segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = builder.segment
    /**
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.
     */
    public val startoverWindowSeconds: kotlin.Int? = builder.startoverWindowSeconds
    /**
     * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOriginEndpointResponse(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("containerType=$containerType,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("hlsManifests=$hlsManifests,")
        append("lowLatencyHlsManifests=$lowLatencyHlsManifests,")
        append("modifiedAt=$modifiedAt,")
        append("originEndpointName=$originEndpointName,")
        append("segment=$segment,")
        append("startoverWindowSeconds=$startoverWindowSeconds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (channelGroupName?.hashCode() ?: 0)
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (lowLatencyHlsManifests?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName?.hashCode() ?: 0)
        result = 31 * result + (segment?.hashCode() ?: 0)
        result = 31 * result + (startoverWindowSeconds ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOriginEndpointResponse

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (containerType != other.containerType) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (hlsManifests != other.hlsManifests) return false
        if (lowLatencyHlsManifests != other.lowLatencyHlsManifests) return false
        if (modifiedAt != other.modifiedAt) return false
        if (originEndpointName != other.originEndpointName) return false
        if (segment != other.segment) return false
        if (startoverWindowSeconds != other.startoverWindowSeconds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN associated with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * The type of container attached to this origin endpoint.
         */
        public var containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = null
        /**
         * The date and time the origin endpoint was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the origin endpoint.
         */
        public var description: kotlin.String? = null
        /**
         * An HTTP live streaming (HLS) manifest configuration.
         */
        public var hlsManifests: List<GetHlsManifestConfiguration>? = null
        /**
         * A low-latency HLS manifest configuration.
         */
        public var lowLatencyHlsManifests: List<GetLowLatencyHlsManifestConfiguration>? = null
        /**
         * The date and time the origin endpoint was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The segment configuration, including the segment name, duration, and other configuration values.
         */
        public var segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = null
        /**
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.
         */
        public var startoverWindowSeconds: kotlin.Int? = null
        /**
         * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointResponse) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.containerType = x.containerType
            this.createdAt = x.createdAt
            this.description = x.description
            this.hlsManifests = x.hlsManifests
            this.lowLatencyHlsManifests = x.lowLatencyHlsManifests
            this.modifiedAt = x.modifiedAt
            this.originEndpointName = x.originEndpointName
            this.segment = x.segment
            this.startoverWindowSeconds = x.startoverWindowSeconds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointResponse = UpdateOriginEndpointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Segment] inside the given [block]
         */
        public fun segment(block: aws.sdk.kotlin.services.mediapackagev2.model.Segment.Builder.() -> kotlin.Unit) {
            this.segment = aws.sdk.kotlin.services.mediapackagev2.model.Segment.invoke(block)
        }
    }
}
