// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model



/**
 * The parameters for the SPEKE key provider.
 */
public class SpekeKeyProvider private constructor(builder: Builder) {
    /**
     * The DRM solution provider you're using to protect your content during distribution.
     */
    public val drmSystems: List<DrmSystem>? = builder.drmSystems
    /**
     * Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.
     */
    public val encryptionContractConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration? = builder.encryptionContractConfiguration
    /**
     * The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.
     *
     * The following example shows a resource ID: `MovieNight20171126093045`
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.
     *
     * Valid format: `arn:aws:iam::{accountID}:role/{name}`. The following example shows a role ARN: `arn:aws:iam::444455556666:role/SpekeAccess`
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.
     *
     * The following example shows a URL: `https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection`
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpekeKeyProvider(")
        append("drmSystems=$drmSystems,")
        append("encryptionContractConfiguration=$encryptionContractConfiguration,")
        append("resourceId=$resourceId,")
        append("roleArn=$roleArn,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = drmSystems?.hashCode() ?: 0
        result = 31 * result + (encryptionContractConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpekeKeyProvider

        if (drmSystems != other.drmSystems) return false
        if (encryptionContractConfiguration != other.encryptionContractConfiguration) return false
        if (resourceId != other.resourceId) return false
        if (roleArn != other.roleArn) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DRM solution provider you're using to protect your content during distribution.
         */
        public var drmSystems: List<DrmSystem>? = null
        /**
         * Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.
         */
        public var encryptionContractConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration? = null
        /**
         * The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.
         *
         * The following example shows a resource ID: `MovieNight20171126093045`
         */
        public var resourceId: kotlin.String? = null
        /**
         * The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.
         *
         * Valid format: `arn:aws:iam::{accountID}:role/{name}`. The following example shows a role ARN: `arn:aws:iam::444455556666:role/SpekeAccess`
         */
        public var roleArn: kotlin.String? = null
        /**
         * The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.
         *
         * The following example shows a URL: `https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection`
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider) : this() {
            this.drmSystems = x.drmSystems
            this.encryptionContractConfiguration = x.encryptionContractConfiguration
            this.resourceId = x.resourceId
            this.roleArn = x.roleArn
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider = SpekeKeyProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration] inside the given [block]
         */
        public fun encryptionContractConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionContractConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration.invoke(block)
        }
    }
}
