// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model



/**
 * The segment configuration, including the segment name, duration, and other configuration values.
 */
public class Segment private constructor(builder: Builder) {
    /**
     * The parameters for encrypting content.
     */
    public val encryption: aws.sdk.kotlin.services.mediapackagev2.model.Encryption? = builder.encryption
    /**
     * When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.
     */
    public val includeIframeOnlyStreams: kotlin.Boolean? = builder.includeIframeOnlyStreams
    /**
     * The SCTE configuration options in the segment settings.
     */
    public val scte: aws.sdk.kotlin.services.mediapackagev2.model.Scte? = builder.scte
    /**
     * The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.
     */
    public val segmentDurationSeconds: kotlin.Int? = builder.segmentDurationSeconds
    /**
     * The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.
     */
    public val segmentName: kotlin.String? = builder.segmentName
    /**
     * By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.
     */
    public val tsIncludeDvbSubtitles: kotlin.Boolean? = builder.tsIncludeDvbSubtitles
    /**
     * When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.
     */
    public val tsUseAudioRenditionGroup: kotlin.Boolean? = builder.tsUseAudioRenditionGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.Segment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Segment(")
        append("encryption=$encryption,")
        append("includeIframeOnlyStreams=$includeIframeOnlyStreams,")
        append("scte=$scte,")
        append("segmentDurationSeconds=$segmentDurationSeconds,")
        append("segmentName=$segmentName,")
        append("tsIncludeDvbSubtitles=$tsIncludeDvbSubtitles,")
        append("tsUseAudioRenditionGroup=$tsUseAudioRenditionGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryption?.hashCode() ?: 0
        result = 31 * result + (includeIframeOnlyStreams?.hashCode() ?: 0)
        result = 31 * result + (scte?.hashCode() ?: 0)
        result = 31 * result + (segmentDurationSeconds ?: 0)
        result = 31 * result + (segmentName?.hashCode() ?: 0)
        result = 31 * result + (tsIncludeDvbSubtitles?.hashCode() ?: 0)
        result = 31 * result + (tsUseAudioRenditionGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Segment

        if (encryption != other.encryption) return false
        if (includeIframeOnlyStreams != other.includeIframeOnlyStreams) return false
        if (scte != other.scte) return false
        if (segmentDurationSeconds != other.segmentDurationSeconds) return false
        if (segmentName != other.segmentName) return false
        if (tsIncludeDvbSubtitles != other.tsIncludeDvbSubtitles) return false
        if (tsUseAudioRenditionGroup != other.tsUseAudioRenditionGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.Segment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The parameters for encrypting content.
         */
        public var encryption: aws.sdk.kotlin.services.mediapackagev2.model.Encryption? = null
        /**
         * When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.
         */
        public var includeIframeOnlyStreams: kotlin.Boolean? = null
        /**
         * The SCTE configuration options in the segment settings.
         */
        public var scte: aws.sdk.kotlin.services.mediapackagev2.model.Scte? = null
        /**
         * The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.
         */
        public var segmentDurationSeconds: kotlin.Int? = null
        /**
         * The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.
         */
        public var segmentName: kotlin.String? = null
        /**
         * By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.
         */
        public var tsIncludeDvbSubtitles: kotlin.Boolean? = null
        /**
         * When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.
         */
        public var tsUseAudioRenditionGroup: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.Segment) : this() {
            this.encryption = x.encryption
            this.includeIframeOnlyStreams = x.includeIframeOnlyStreams
            this.scte = x.scte
            this.segmentDurationSeconds = x.segmentDurationSeconds
            this.segmentName = x.segmentName
            this.tsIncludeDvbSubtitles = x.tsIncludeDvbSubtitles
            this.tsUseAudioRenditionGroup = x.tsUseAudioRenditionGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.Segment = Segment(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediapackagev2.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediapackagev2.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Scte] inside the given [block]
         */
        public fun scte(block: aws.sdk.kotlin.services.mediapackagev2.model.Scte.Builder.() -> kotlin.Unit) {
            this.scte = aws.sdk.kotlin.services.mediapackagev2.model.Scte.invoke(block)
        }
    }
}
