// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.waiters

import aws.sdk.kotlin.services.mediapackagev2.MediaPackageV2Client
import aws.sdk.kotlin.services.mediapackagev2.model.GetHarvestJobRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetHarvestJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


public suspend fun MediaPackageV2Client.waitUntilHarvestJobFinished(request: GetHarvestJobRequest): Outcome<GetHarvestJobResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetHarvestJobRequest, GetHarvestJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "COMPLETED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "CANCELLED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "QUEUED"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "IN_PROGRESS"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getHarvestJob(request) }
}

public suspend fun MediaPackageV2Client.waitUntilHarvestJobFinished(block: GetHarvestJobRequest.Builder.() -> Unit): Outcome<GetHarvestJobResponse> =
    waitUntilHarvestJobFinished(GetHarvestJobRequest.Builder().apply(block).build())
