// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.serde

import aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobRequest
import aws.sdk.kotlin.services.mediapackagev2.model.Destination
import aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests
import aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateHarvestJobOperationSerializer: HttpSerializer.NonStreaming<CreateHarvestJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateHarvestJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.channelGroupName) { "channelGroupName is bound to the URI and must not be null" }
            requireNotNull(input.channelName) { "channelName is bound to the URI and must not be null" }
            requireNotNull(input.originEndpointName) { "originEndpointName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channelGroup"))
                add(PercentEncoding.SmithyLabel.encode(input.channelGroupName))
                add(PercentEncoding.Path.encode("channel"))
                add(PercentEncoding.SmithyLabel.encode(input.channelName))
                add(PercentEncoding.Path.encode("originEndpoint"))
                add(PercentEncoding.SmithyLabel.encode(input.originEndpointName))
                add(PercentEncoding.Path.encode("harvestJob"))
            }
        }

        builder.headers {
            append("x-amzn-client-token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeCreateHarvestJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateHarvestJobOperationBody(context: ExecutionContext, input: CreateHarvestJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val HARVESTJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HarvestJobName"))
    val HARVESTEDMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HarvestedManifests"))
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(HARVESTJOBNAME_DESCRIPTOR)
        field(HARVESTEDMANIFESTS_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it, ::serializeDestinationDocument) }
        input.harvestJobName?.let { field(HARVESTJOBNAME_DESCRIPTOR, it) }
        input.harvestedManifests?.let { field(HARVESTEDMANIFESTS_DESCRIPTOR, it, ::serializeHarvestedManifestsDocument) }
        input.scheduleConfiguration?.let { field(SCHEDULECONFIGURATION_DESCRIPTOR, it, ::serializeHarvesterScheduleConfigurationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
