// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.serde

import aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobResponse
import aws.sdk.kotlin.services.mediapackagev2.model.Destination
import aws.sdk.kotlin.services.mediapackagev2.model.HarvestJobStatus
import aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests
import aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.MediaPackageV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class CreateHarvestJobOperationDeserializer: HttpDeserializer.NonStreaming<CreateHarvestJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateHarvestJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateHarvestJobError(context, call, payload)
        }
        val builder = CreateHarvestJobResponse.Builder()

        if (payload != null) {
            deserializeCreateHarvestJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateHarvestJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MediaPackageV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHarvestJobOperationBody(builder: CreateHarvestJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CHANNELGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelGroupName"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val ETAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ETag"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val HARVESTJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HarvestJobName"))
    val HARVESTEDMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HarvestedManifests"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedAt"))
    val ORIGINENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginEndpointName"))
    val SCHEDULECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ScheduleConfiguration"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CHANNELGROUPNAME_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(ETAG_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(HARVESTJOBNAME_DESCRIPTOR)
        field(HARVESTEDMANIFESTS_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(ORIGINENDPOINTNAME_DESCRIPTOR)
        field(SCHEDULECONFIGURATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHANNELGROUPNAME_DESCRIPTOR.index -> builder.channelGroupName = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeDestinationDocument(deserializer)
                ETAG_DESCRIPTOR.index -> builder.eTag = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                HARVESTJOBNAME_DESCRIPTOR.index -> builder.harvestJobName = deserializeString()
                HARVESTEDMANIFESTS_DESCRIPTOR.index -> builder.harvestedManifests = deserializeHarvestedManifestsDocument(deserializer)
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ORIGINENDPOINTNAME_DESCRIPTOR.index -> builder.originEndpointName = deserializeString()
                SCHEDULECONFIGURATION_DESCRIPTOR.index -> builder.scheduleConfiguration = deserializeHarvesterScheduleConfigurationDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { HarvestJobStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
