// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration parameters for where in an S3 bucket to place the harvested content.
 */
public class S3DestinationConfig private constructor(builder: Builder) {
    /**
     * The name of an S3 bucket within which harvested content will be exported.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The path within the specified S3 bucket where the harvested content will be placed.
     */
    public val destinationPath: kotlin.String = requireNotNull(builder.destinationPath) { "A non-null value must be provided for destinationPath" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.S3DestinationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationConfig(")
        append("bucketName=$bucketName,")
        append("destinationPath=$destinationPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (destinationPath.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationConfig

        if (bucketName != other.bucketName) return false
        if (destinationPath != other.destinationPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.S3DestinationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an S3 bucket within which harvested content will be exported.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The path within the specified S3 bucket where the harvested content will be placed.
         */
        public var destinationPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.S3DestinationConfig) : this() {
            this.bucketName = x.bucketName
            this.destinationPath = x.destinationPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.S3DestinationConfig = S3DestinationConfig(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (destinationPath == null) destinationPath = ""
            return this
        }
    }
}
