// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object for listing harvest jobs.
 */
public class ListHarvestJobsRequest private constructor(builder: Builder) {
    /**
     * The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs associated with channels in this group will be returned.
     */
    public val channelGroupName: kotlin.String? = builder.channelGroupName
    /**
     * The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with this channel will be returned.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * The maximum number of harvest jobs to return in a single request. If not specified, a default value will be used.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used for pagination. Provide this value in subsequent requests to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs associated with this origin endpoint will be returned.
     */
    public val originEndpointName: kotlin.String? = builder.originEndpointName
    /**
     * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
     */
    public val status: aws.sdk.kotlin.services.mediapackagev2.model.HarvestJobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.ListHarvestJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHarvestJobsRequest(")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("originEndpointName=$originEndpointName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelGroupName?.hashCode() ?: 0
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHarvestJobsRequest

        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (originEndpointName != other.originEndpointName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.ListHarvestJobsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the channel group to filter the harvest jobs by. If specified, only harvest jobs associated with channels in this group will be returned.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name of the channel to filter the harvest jobs by. If specified, only harvest jobs associated with this channel will be returned.
         */
        public var channelName: kotlin.String? = null
        /**
         * The maximum number of harvest jobs to return in a single request. If not specified, a default value will be used.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used for pagination. Provide this value in subsequent requests to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the origin endpoint to filter the harvest jobs by. If specified, only harvest jobs associated with this origin endpoint will be returned.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The status to filter the harvest jobs by. If specified, only harvest jobs with this status will be returned.
         */
        public var status: aws.sdk.kotlin.services.mediapackagev2.model.HarvestJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.ListHarvestJobsRequest) : this() {
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.originEndpointName = x.originEndpointName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.ListHarvestJobsRequest = ListHarvestJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
