// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateOriginEndpointRequest private constructor(builder: Builder) {
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String? = builder.channelGroupName
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file. You can't change the container type after you create the endpoint.
     */
    public val containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = builder.containerType
    /**
     * A DASH manifest configuration.
     */
    public val dashManifests: List<CreateDashManifestConfiguration>? = builder.dashManifests
    /**
     * Enter any descriptive text that helps you to identify the origin endpoint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The failover settings for the endpoint.
     */
    public val forceEndpointErrorConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.ForceEndpointErrorConfiguration? = builder.forceEndpointErrorConfiguration
    /**
     * An HTTP live streaming (HLS) manifest configuration.
     */
    public val hlsManifests: List<CreateHlsManifestConfiguration>? = builder.hlsManifests
    /**
     * A low-latency HLS manifest configuration.
     */
    public val lowLatencyHlsManifests: List<CreateLowLatencyHlsManifestConfiguration>? = builder.lowLatencyHlsManifests
    /**
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and must be unique for your account in the AWS Region and channel. You can't use spaces in the name. You can't change the name after you create the endpoint.
     */
    public val originEndpointName: kotlin.String? = builder.originEndpointName
    /**
     * The segment configuration, including the segment name, duration, and other configuration values.
     */
    public val segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = builder.segment
    /**
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).
     */
    public val startoverWindowSeconds: kotlin.Int? = builder.startoverWindowSeconds
    /**
     * A comma-separated list of tag key:value pairs that you define. For example:
     *
     * `"Key1": "Value1",`
     *
     * `"Key2": "Value2"`
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOriginEndpointRequest(")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("clientToken=$clientToken,")
        append("containerType=$containerType,")
        append("dashManifests=$dashManifests,")
        append("description=$description,")
        append("forceEndpointErrorConfiguration=$forceEndpointErrorConfiguration,")
        append("hlsManifests=$hlsManifests,")
        append("lowLatencyHlsManifests=$lowLatencyHlsManifests,")
        append("originEndpointName=$originEndpointName,")
        append("segment=$segment,")
        append("startoverWindowSeconds=$startoverWindowSeconds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelGroupName?.hashCode() ?: 0
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (dashManifests?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forceEndpointErrorConfiguration?.hashCode() ?: 0)
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (lowLatencyHlsManifests?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName?.hashCode() ?: 0)
        result = 31 * result + (segment?.hashCode() ?: 0)
        result = 31 * result + (startoverWindowSeconds ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOriginEndpointRequest

        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (clientToken != other.clientToken) return false
        if (containerType != other.containerType) return false
        if (dashManifests != other.dashManifests) return false
        if (description != other.description) return false
        if (forceEndpointErrorConfiguration != other.forceEndpointErrorConfiguration) return false
        if (hlsManifests != other.hlsManifests) return false
        if (lowLatencyHlsManifests != other.lowLatencyHlsManifests) return false
        if (originEndpointName != other.originEndpointName) return false
        if (segment != other.segment) return false
        if (startoverWindowSeconds != other.startoverWindowSeconds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The type of container to attach to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file. You can't change the container type after you create the endpoint.
         */
        public var containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = null
        /**
         * A DASH manifest configuration.
         */
        public var dashManifests: List<CreateDashManifestConfiguration>? = null
        /**
         * Enter any descriptive text that helps you to identify the origin endpoint.
         */
        public var description: kotlin.String? = null
        /**
         * The failover settings for the endpoint.
         */
        public var forceEndpointErrorConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.ForceEndpointErrorConfiguration? = null
        /**
         * An HTTP live streaming (HLS) manifest configuration.
         */
        public var hlsManifests: List<CreateHlsManifestConfiguration>? = null
        /**
         * A low-latency HLS manifest configuration.
         */
        public var lowLatencyHlsManifests: List<CreateLowLatencyHlsManifestConfiguration>? = null
        /**
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and must be unique for your account in the AWS Region and channel. You can't use spaces in the name. You can't change the name after you create the endpoint.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The segment configuration, including the segment name, duration, and other configuration values.
         */
        public var segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = null
        /**
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).
         */
        public var startoverWindowSeconds: kotlin.Int? = null
        /**
         * A comma-separated list of tag key:value pairs that you define. For example:
         *
         * `"Key1": "Value1",`
         *
         * `"Key2": "Value2"`
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointRequest) : this() {
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.clientToken = x.clientToken
            this.containerType = x.containerType
            this.dashManifests = x.dashManifests
            this.description = x.description
            this.forceEndpointErrorConfiguration = x.forceEndpointErrorConfiguration
            this.hlsManifests = x.hlsManifests
            this.lowLatencyHlsManifests = x.lowLatencyHlsManifests
            this.originEndpointName = x.originEndpointName
            this.segment = x.segment
            this.startoverWindowSeconds = x.startoverWindowSeconds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointRequest = CreateOriginEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.ForceEndpointErrorConfiguration] inside the given [block]
         */
        public fun forceEndpointErrorConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.ForceEndpointErrorConfiguration.Builder.() -> kotlin.Unit) {
            this.forceEndpointErrorConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.ForceEndpointErrorConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Segment] inside the given [block]
         */
        public fun segment(block: aws.sdk.kotlin.services.mediapackagev2.model.Segment.Builder.() -> kotlin.Unit) {
            this.segment = aws.sdk.kotlin.services.mediapackagev2.model.Segment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
