// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The response object returned after creating a harvest job.
 */
public class CreateHarvestJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the created harvest job.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name of the channel group containing the channel from which content is being harvested.
     */
    public val channelGroupName: kotlin.String = requireNotNull(builder.channelGroupName) { "A non-null value must be provided for channelGroupName" }
    /**
     * The name of the channel from which content is being harvested.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The date and time the harvest job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the harvest job, if provided.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The S3 destination where the harvested content will be placed.
     */
    public val destination: aws.sdk.kotlin.services.mediapackagev2.model.Destination? = builder.destination
    /**
     * The current version of the harvest job. Used for concurrency control.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * An error message if the harvest job creation failed.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The name of the created harvest job.
     */
    public val harvestJobName: kotlin.String = requireNotNull(builder.harvestJobName) { "A non-null value must be provided for harvestJobName" }
    /**
     * A list of manifests that will be harvested.
     */
    public val harvestedManifests: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests? = builder.harvestedManifests
    /**
     * The date and time the harvest job was last modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The name of the origin endpoint from which content is being harvested.
     */
    public val originEndpointName: kotlin.String = requireNotNull(builder.originEndpointName) { "A non-null value must be provided for originEndpointName" }
    /**
     * The configuration for when the harvest job will run, including start and end times.
     */
    public val scheduleConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration? = builder.scheduleConfiguration
    /**
     * The current status of the harvest job (e.g., CREATED, IN_PROGRESS, ABORTED, COMPLETED, FAILED).
     */
    public val status: aws.sdk.kotlin.services.mediapackagev2.model.HarvestJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A collection of tags associated with the harvest job.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHarvestJobResponse(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("destination=$destination,")
        append("eTag=$eTag,")
        append("errorMessage=$errorMessage,")
        append("harvestJobName=$harvestJobName,")
        append("harvestedManifests=$harvestedManifests,")
        append("modifiedAt=$modifiedAt,")
        append("originEndpointName=$originEndpointName,")
        append("scheduleConfiguration=$scheduleConfiguration,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelGroupName.hashCode())
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (harvestJobName.hashCode())
        result = 31 * result + (harvestedManifests?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (originEndpointName.hashCode())
        result = 31 * result + (scheduleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHarvestJobResponse

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (eTag != other.eTag) return false
        if (errorMessage != other.errorMessage) return false
        if (harvestJobName != other.harvestJobName) return false
        if (harvestedManifests != other.harvestedManifests) return false
        if (modifiedAt != other.modifiedAt) return false
        if (originEndpointName != other.originEndpointName) return false
        if (scheduleConfiguration != other.scheduleConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the created harvest job.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the channel group containing the channel from which content is being harvested.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name of the channel from which content is being harvested.
         */
        public var channelName: kotlin.String? = null
        /**
         * The date and time the harvest job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the harvest job, if provided.
         */
        public var description: kotlin.String? = null
        /**
         * The S3 destination where the harvested content will be placed.
         */
        public var destination: aws.sdk.kotlin.services.mediapackagev2.model.Destination? = null
        /**
         * The current version of the harvest job. Used for concurrency control.
         */
        public var eTag: kotlin.String? = null
        /**
         * An error message if the harvest job creation failed.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The name of the created harvest job.
         */
        public var harvestJobName: kotlin.String? = null
        /**
         * A list of manifests that will be harvested.
         */
        public var harvestedManifests: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests? = null
        /**
         * The date and time the harvest job was last modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the origin endpoint from which content is being harvested.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The configuration for when the harvest job will run, including start and end times.
         */
        public var scheduleConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration? = null
        /**
         * The current status of the harvest job (e.g., CREATED, IN_PROGRESS, ABORTED, COMPLETED, FAILED).
         */
        public var status: aws.sdk.kotlin.services.mediapackagev2.model.HarvestJobStatus? = null
        /**
         * A collection of tags associated with the harvest job.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobResponse) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.createdAt = x.createdAt
            this.description = x.description
            this.destination = x.destination
            this.eTag = x.eTag
            this.errorMessage = x.errorMessage
            this.harvestJobName = x.harvestJobName
            this.harvestedManifests = x.harvestedManifests
            this.modifiedAt = x.modifiedAt
            this.originEndpointName = x.originEndpointName
            this.scheduleConfiguration = x.scheduleConfiguration
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobResponse = CreateHarvestJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.mediapackagev2.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.mediapackagev2.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests] inside the given [block]
         */
        public fun harvestedManifests(block: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests.Builder.() -> kotlin.Unit) {
            this.harvestedManifests = aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration] inside the given [block]
         */
        public fun scheduleConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration.Builder.() -> kotlin.Unit) {
            this.scheduleConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelGroupName == null) channelGroupName = ""
            if (channelName == null) channelName = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (harvestJobName == null) harvestJobName = ""
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (originEndpointName == null) originEndpointName = ""
            if (status == null) status = HarvestJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
