// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object for creating a new harvest job.
 */
public class CreateHarvestJobRequest private constructor(builder: Builder) {
    /**
     * The name of the channel group containing the channel from which to harvest content.
     */
    public val channelGroupName: kotlin.String? = builder.channelGroupName
    /**
     * The name of the channel from which to harvest content.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * An optional description for the harvest job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The S3 destination where the harvested content will be placed.
     */
    public val destination: aws.sdk.kotlin.services.mediapackagev2.model.Destination? = builder.destination
    /**
     * A name for the harvest job. This name must be unique within the channel.
     */
    public val harvestJobName: kotlin.String? = builder.harvestJobName
    /**
     * A list of manifests to be harvested.
     */
    public val harvestedManifests: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests? = builder.harvestedManifests
    /**
     * The name of the origin endpoint from which to harvest content.
     */
    public val originEndpointName: kotlin.String? = builder.originEndpointName
    /**
     * The configuration for when the harvest job should run, including start and end times.
     */
    public val scheduleConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration? = builder.scheduleConfiguration
    /**
     * A collection of tags associated with the harvest job.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHarvestJobRequest(")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("destination=$destination,")
        append("harvestJobName=$harvestJobName,")
        append("harvestedManifests=$harvestedManifests,")
        append("originEndpointName=$originEndpointName,")
        append("scheduleConfiguration=$scheduleConfiguration,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelGroupName?.hashCode() ?: 0
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (harvestJobName?.hashCode() ?: 0)
        result = 31 * result + (harvestedManifests?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName?.hashCode() ?: 0)
        result = 31 * result + (scheduleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHarvestJobRequest

        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (harvestJobName != other.harvestJobName) return false
        if (harvestedManifests != other.harvestedManifests) return false
        if (originEndpointName != other.originEndpointName) return false
        if (scheduleConfiguration != other.scheduleConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the channel group containing the channel from which to harvest content.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name of the channel from which to harvest content.
         */
        public var channelName: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * An optional description for the harvest job.
         */
        public var description: kotlin.String? = null
        /**
         * The S3 destination where the harvested content will be placed.
         */
        public var destination: aws.sdk.kotlin.services.mediapackagev2.model.Destination? = null
        /**
         * A name for the harvest job. This name must be unique within the channel.
         */
        public var harvestJobName: kotlin.String? = null
        /**
         * A list of manifests to be harvested.
         */
        public var harvestedManifests: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests? = null
        /**
         * The name of the origin endpoint from which to harvest content.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The configuration for when the harvest job should run, including start and end times.
         */
        public var scheduleConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration? = null
        /**
         * A collection of tags associated with the harvest job.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobRequest) : this() {
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.clientToken = x.clientToken
            this.description = x.description
            this.destination = x.destination
            this.harvestJobName = x.harvestJobName
            this.harvestedManifests = x.harvestedManifests
            this.originEndpointName = x.originEndpointName
            this.scheduleConfiguration = x.scheduleConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.CreateHarvestJobRequest = CreateHarvestJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.mediapackagev2.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.mediapackagev2.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests] inside the given [block]
         */
        public fun harvestedManifests(block: aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests.Builder.() -> kotlin.Unit) {
            this.harvestedManifests = aws.sdk.kotlin.services.mediapackagev2.model.HarvestedManifests.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration] inside the given [block]
         */
        public fun scheduleConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration.Builder.() -> kotlin.Unit) {
            this.scheduleConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.HarvesterScheduleConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
