// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateChannelResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) associated with the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String = requireNotNull(builder.channelGroupName) { "A non-null value must be provided for channelGroupName" }
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The date and time the channel was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description for your channel.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * The list of ingest endpoints.
     */
    public val ingestEndpoints: List<IngestEndpoint>? = builder.ingestEndpoints
    /**
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     *
     * The allowed values are:
     * + `HLS` - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * + `CMAF` - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).
     */
    public val inputType: aws.sdk.kotlin.services.mediapackagev2.model.InputType? = builder.inputType
    /**
     * The date and time the channel was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The comma-separated list of tag key:value pairs assigned to the channel.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelResponse(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("eTag=$eTag,")
        append("ingestEndpoints=$ingestEndpoints,")
        append("inputType=$inputType,")
        append("modifiedAt=$modifiedAt,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelGroupName.hashCode())
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (ingestEndpoints?.hashCode() ?: 0)
        result = 31 * result + (inputType?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelResponse

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (eTag != other.eTag) return false
        if (ingestEndpoints != other.ingestEndpoints) return false
        if (inputType != other.inputType) return false
        if (modifiedAt != other.modifiedAt) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) associated with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * The date and time the channel was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for your channel.
         */
        public var description: kotlin.String? = null
        /**
         * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent updates to the resource.
         */
        public var eTag: kotlin.String? = null
        /**
         * The list of ingest endpoints.
         */
        public var ingestEndpoints: List<IngestEndpoint>? = null
        /**
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         *
         * The allowed values are:
         * + `HLS` - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * + `CMAF` - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH manifests).
         */
        public var inputType: aws.sdk.kotlin.services.mediapackagev2.model.InputType? = null
        /**
         * The date and time the channel was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The comma-separated list of tag key:value pairs assigned to the channel.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelResponse) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.createdAt = x.createdAt
            this.description = x.description
            this.eTag = x.eTag
            this.ingestEndpoints = x.ingestEndpoints
            this.inputType = x.inputType
            this.modifiedAt = x.modifiedAt
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelResponse = CreateChannelResponse(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelGroupName == null) channelGroupName = ""
            if (channelName == null) channelName = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
