// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.paginators

import aws.sdk.kotlin.services.mediapackagev2.MediaPackageV2Client
import aws.sdk.kotlin.services.mediapackagev2.model.ChannelGroupListConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.ChannelListConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelGroupsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelGroupsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListOriginEndpointsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListOriginEndpointsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.OriginEndpointListConfiguration
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListChannelGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelGroupsResponse]
 */
public fun MediaPackageV2Client.listChannelGroupsPaginated(initialRequest: ListChannelGroupsRequest = ListChannelGroupsRequest { }): Flow<ListChannelGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelGroupsPaginated.listChannelGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelGroupsResponse]
 */
public fun MediaPackageV2Client.listChannelGroupsPaginated(block: ListChannelGroupsRequest.Builder.() -> Unit): Flow<ListChannelGroupsResponse> =
    listChannelGroupsPaginated(ListChannelGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelGroupsPaginated]
 * to access the nested member [ChannelGroupListConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChannelGroupListConfiguration]
 */
@JvmName("listChannelGroupsResponseChannelGroupListConfiguration")
public fun Flow<ListChannelGroupsResponse>.items(): Flow<ChannelGroupListConfiguration> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaPackageV2Client.listChannelsPaginated(initialRequest: ListChannelsRequest): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun MediaPackageV2Client.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChannelsPaginated]
 * to access the nested member [ChannelListConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChannelListConfiguration]
 */
@JvmName("listChannelsResponseChannelListConfiguration")
public fun Flow<ListChannelsResponse>.items(): Flow<ChannelListConfiguration> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOriginEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOriginEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginEndpointsResponse]
 */
public fun MediaPackageV2Client.listOriginEndpointsPaginated(initialRequest: ListOriginEndpointsRequest): Flow<ListOriginEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOriginEndpointsPaginated.listOriginEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOriginEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOriginEndpointsResponse]
 */
public fun MediaPackageV2Client.listOriginEndpointsPaginated(block: ListOriginEndpointsRequest.Builder.() -> Unit): Flow<ListOriginEndpointsResponse> =
    listOriginEndpointsPaginated(ListOriginEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOriginEndpointsPaginated]
 * to access the nested member [OriginEndpointListConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OriginEndpointListConfiguration]
 */
@JvmName("listOriginEndpointsResponseOriginEndpointListConfiguration")
public fun Flow<ListOriginEndpointsResponse>.items(): Flow<OriginEndpointListConfiguration> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
