// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Retrieve the HTTP live streaming (HLS) manifest configuration.
 */
public class GetHlsManifestConfiguration private constructor(builder: Builder) {
    /**
     * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
     */
    public val childManifestName: kotlin.String? = builder.childManifestName
    /**
     * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
     */
    public val filterConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration? = builder.filterConfiguration
    /**
     * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
     */
    public val manifestName: kotlin.String = requireNotNull(builder.manifestName) { "A non-null value must be provided for manifestName" }
    /**
     * The total duration (in seconds) of the manifest's content.
     */
    public val manifestWindowSeconds: kotlin.Int? = builder.manifestWindowSeconds
    /**
     * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.
     *
     * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
     */
    public val programDateTimeIntervalSeconds: kotlin.Int? = builder.programDateTimeIntervalSeconds
    /**
     * The SCTE configuration.
     */
    public val scteHls: aws.sdk.kotlin.services.mediapackagev2.model.ScteHls? = builder.scteHls
    /**
     * The egress domain URL for stream delivery from MediaPackage.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetHlsManifestConfiguration(")
        append("childManifestName=$childManifestName,")
        append("filterConfiguration=$filterConfiguration,")
        append("manifestName=$manifestName,")
        append("manifestWindowSeconds=$manifestWindowSeconds,")
        append("programDateTimeIntervalSeconds=$programDateTimeIntervalSeconds,")
        append("scteHls=$scteHls,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childManifestName?.hashCode() ?: 0
        result = 31 * result + (filterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (manifestName.hashCode())
        result = 31 * result + (manifestWindowSeconds ?: 0)
        result = 31 * result + (programDateTimeIntervalSeconds ?: 0)
        result = 31 * result + (scteHls?.hashCode() ?: 0)
        result = 31 * result + (url.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetHlsManifestConfiguration

        if (childManifestName != other.childManifestName) return false
        if (filterConfiguration != other.filterConfiguration) return false
        if (manifestName != other.manifestName) return false
        if (manifestWindowSeconds != other.manifestWindowSeconds) return false
        if (programDateTimeIntervalSeconds != other.programDateTimeIntervalSeconds) return false
        if (scteHls != other.scteHls) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         */
        public var childManifestName: kotlin.String? = null
        /**
         * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         */
        public var filterConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration? = null
        /**
         * A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.
         */
        public var manifestName: kotlin.String? = null
        /**
         * The total duration (in seconds) of the manifest's content.
         */
        public var manifestWindowSeconds: kotlin.Int? = null
        /**
         * Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player. ID3Timed metadata messages generate every 5 seconds whenever the content is ingested.
         *
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
         */
        public var programDateTimeIntervalSeconds: kotlin.Int? = null
        /**
         * The SCTE configuration.
         */
        public var scteHls: aws.sdk.kotlin.services.mediapackagev2.model.ScteHls? = null
        /**
         * The egress domain URL for stream delivery from MediaPackage.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration) : this() {
            this.childManifestName = x.childManifestName
            this.filterConfiguration = x.filterConfiguration
            this.manifestName = x.manifestName
            this.manifestWindowSeconds = x.manifestWindowSeconds
            this.programDateTimeIntervalSeconds = x.programDateTimeIntervalSeconds
            this.scteHls = x.scteHls
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration = GetHlsManifestConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration] inside the given [block]
         */
        public fun filterConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration.Builder.() -> kotlin.Unit) {
            this.filterConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.ScteHls] inside the given [block]
         */
        public fun scteHls(block: aws.sdk.kotlin.services.mediapackagev2.model.ScteHls.Builder.() -> kotlin.Unit) {
            this.scteHls = aws.sdk.kotlin.services.mediapackagev2.model.ScteHls.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (manifestName == null) manifestName = ""
            if (url == null) url = ""
            return this
        }
    }
}
