// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Retrieve the DASH manifest configuration.
 */
public class GetDashManifestConfiguration private constructor(builder: Builder) {
    /**
     * Determines how the DASH manifest signals the DRM content.
     */
    public val drmSignaling: aws.sdk.kotlin.services.mediapackagev2.model.DashDrmSignaling? = builder.drmSignaling
    /**
     * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
     */
    public val filterConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration? = builder.filterConfiguration
    /**
     * A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
     */
    public val manifestName: kotlin.String = requireNotNull(builder.manifestName) { "A non-null value must be provided for manifestName" }
    /**
     * The total duration (in seconds) of the manifest's content.
     */
    public val manifestWindowSeconds: kotlin.Int? = builder.manifestWindowSeconds
    /**
     * Minimum amount of content (in seconds) that a player must keep available in the buffer.
     */
    public val minBufferTimeSeconds: kotlin.Int? = builder.minBufferTimeSeconds
    /**
     * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
     */
    public val minUpdatePeriodSeconds: kotlin.Int? = builder.minUpdatePeriodSeconds
    /**
     * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see [Multi-period DASH in AWS Elemental MediaPackage](https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html).
     */
    public val periodTriggers: List<DashPeriodTrigger>? = builder.periodTriggers
    /**
     * The SCTE configuration.
     */
    public val scteDash: aws.sdk.kotlin.services.mediapackagev2.model.ScteDash? = builder.scteDash
    /**
     * Determines the type of variable used in the `media` URL of the `SegmentTemplate` tag in the manifest. Also specifies if segment timeline information is included in `SegmentTimeline` or `SegmentTemplate`.
     *
     * Value description:
     * + `NUMBER_WITH_TIMELINE` - The `$Number$` variable is used in the `media` URL. The value of this variable is the sequential number of the segment. A full `SegmentTimeline` object is presented in each `SegmentTemplate`.
     */
    public val segmentTemplateFormat: aws.sdk.kotlin.services.mediapackagev2.model.DashSegmentTemplateFormat? = builder.segmentTemplateFormat
    /**
     * The amount of time (in seconds) that the player should be from the end of the manifest.
     */
    public val suggestedPresentationDelaySeconds: kotlin.Int? = builder.suggestedPresentationDelaySeconds
    /**
     * The egress domain URL for stream delivery from MediaPackage.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }
    /**
     * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
     */
    public val utcTiming: aws.sdk.kotlin.services.mediapackagev2.model.DashUtcTiming? = builder.utcTiming

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.GetDashManifestConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDashManifestConfiguration(")
        append("drmSignaling=$drmSignaling,")
        append("filterConfiguration=$filterConfiguration,")
        append("manifestName=$manifestName,")
        append("manifestWindowSeconds=$manifestWindowSeconds,")
        append("minBufferTimeSeconds=$minBufferTimeSeconds,")
        append("minUpdatePeriodSeconds=$minUpdatePeriodSeconds,")
        append("periodTriggers=$periodTriggers,")
        append("scteDash=$scteDash,")
        append("segmentTemplateFormat=$segmentTemplateFormat,")
        append("suggestedPresentationDelaySeconds=$suggestedPresentationDelaySeconds,")
        append("url=$url,")
        append("utcTiming=$utcTiming")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = drmSignaling?.hashCode() ?: 0
        result = 31 * result + (filterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (manifestName.hashCode())
        result = 31 * result + (manifestWindowSeconds ?: 0)
        result = 31 * result + (minBufferTimeSeconds ?: 0)
        result = 31 * result + (minUpdatePeriodSeconds ?: 0)
        result = 31 * result + (periodTriggers?.hashCode() ?: 0)
        result = 31 * result + (scteDash?.hashCode() ?: 0)
        result = 31 * result + (segmentTemplateFormat?.hashCode() ?: 0)
        result = 31 * result + (suggestedPresentationDelaySeconds ?: 0)
        result = 31 * result + (url.hashCode())
        result = 31 * result + (utcTiming?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDashManifestConfiguration

        if (drmSignaling != other.drmSignaling) return false
        if (filterConfiguration != other.filterConfiguration) return false
        if (manifestName != other.manifestName) return false
        if (manifestWindowSeconds != other.manifestWindowSeconds) return false
        if (minBufferTimeSeconds != other.minBufferTimeSeconds) return false
        if (minUpdatePeriodSeconds != other.minUpdatePeriodSeconds) return false
        if (periodTriggers != other.periodTriggers) return false
        if (scteDash != other.scteDash) return false
        if (segmentTemplateFormat != other.segmentTemplateFormat) return false
        if (suggestedPresentationDelaySeconds != other.suggestedPresentationDelaySeconds) return false
        if (url != other.url) return false
        if (utcTiming != other.utcTiming) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.GetDashManifestConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines how the DASH manifest signals the DRM content.
         */
        public var drmSignaling: aws.sdk.kotlin.services.mediapackagev2.model.DashDrmSignaling? = null
        /**
         * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         */
        public var filterConfiguration: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration? = null
        /**
         * A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index.
         */
        public var manifestName: kotlin.String? = null
        /**
         * The total duration (in seconds) of the manifest's content.
         */
        public var manifestWindowSeconds: kotlin.Int? = null
        /**
         * Minimum amount of content (in seconds) that a player must keep available in the buffer.
         */
        public var minBufferTimeSeconds: kotlin.Int? = null
        /**
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         */
        public var minUpdatePeriodSeconds: kotlin.Int? = null
        /**
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see [Multi-period DASH in AWS Elemental MediaPackage](https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html).
         */
        public var periodTriggers: List<DashPeriodTrigger>? = null
        /**
         * The SCTE configuration.
         */
        public var scteDash: aws.sdk.kotlin.services.mediapackagev2.model.ScteDash? = null
        /**
         * Determines the type of variable used in the `media` URL of the `SegmentTemplate` tag in the manifest. Also specifies if segment timeline information is included in `SegmentTimeline` or `SegmentTemplate`.
         *
         * Value description:
         * + `NUMBER_WITH_TIMELINE` - The `$Number$` variable is used in the `media` URL. The value of this variable is the sequential number of the segment. A full `SegmentTimeline` object is presented in each `SegmentTemplate`.
         */
        public var segmentTemplateFormat: aws.sdk.kotlin.services.mediapackagev2.model.DashSegmentTemplateFormat? = null
        /**
         * The amount of time (in seconds) that the player should be from the end of the manifest.
         */
        public var suggestedPresentationDelaySeconds: kotlin.Int? = null
        /**
         * The egress domain URL for stream delivery from MediaPackage.
         */
        public var url: kotlin.String? = null
        /**
         * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         */
        public var utcTiming: aws.sdk.kotlin.services.mediapackagev2.model.DashUtcTiming? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.GetDashManifestConfiguration) : this() {
            this.drmSignaling = x.drmSignaling
            this.filterConfiguration = x.filterConfiguration
            this.manifestName = x.manifestName
            this.manifestWindowSeconds = x.manifestWindowSeconds
            this.minBufferTimeSeconds = x.minBufferTimeSeconds
            this.minUpdatePeriodSeconds = x.minUpdatePeriodSeconds
            this.periodTriggers = x.periodTriggers
            this.scteDash = x.scteDash
            this.segmentTemplateFormat = x.segmentTemplateFormat
            this.suggestedPresentationDelaySeconds = x.suggestedPresentationDelaySeconds
            this.url = x.url
            this.utcTiming = x.utcTiming
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.GetDashManifestConfiguration = GetDashManifestConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration] inside the given [block]
         */
        public fun filterConfiguration(block: aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration.Builder.() -> kotlin.Unit) {
            this.filterConfiguration = aws.sdk.kotlin.services.mediapackagev2.model.FilterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.ScteDash] inside the given [block]
         */
        public fun scteDash(block: aws.sdk.kotlin.services.mediapackagev2.model.ScteDash.Builder.() -> kotlin.Unit) {
            this.scteDash = aws.sdk.kotlin.services.mediapackagev2.model.ScteDash.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.DashUtcTiming] inside the given [block]
         */
        public fun utcTiming(block: aws.sdk.kotlin.services.mediapackagev2.model.DashUtcTiming.Builder.() -> kotlin.Unit) {
            this.utcTiming = aws.sdk.kotlin.services.mediapackagev2.model.DashUtcTiming.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (manifestName == null) manifestName = ""
            if (url == null) url = ""
            return this
        }
    }
}
