// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.serde

import aws.sdk.kotlin.services.mediapackagev2.model.ContainerType
import aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetDashManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.MediaPackageV2Exception
import aws.sdk.kotlin.services.mediapackagev2.model.Segment
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateOriginEndpointOperationDeserializer: HttpDeserializer.NonStreaming<CreateOriginEndpointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateOriginEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateOriginEndpointError(context, call, payload)
        }
        val builder = CreateOriginEndpointResponse.Builder()

        if (payload != null) {
            deserializeCreateOriginEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateOriginEndpointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MediaPackageV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOriginEndpointOperationBody(builder: CreateOriginEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CHANNELGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelGroupName"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val CONTAINERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ContainerType"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DASHMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DashManifests"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ETAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ETag"))
    val HLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HlsManifests"))
    val LOWLATENCYHLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LowLatencyHlsManifests"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedAt"))
    val ORIGINENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginEndpointName"))
    val SEGMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Segment"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StartoverWindowSeconds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CHANNELGROUPNAME_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CONTAINERTYPE_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DASHMANIFESTS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ETAG_DESCRIPTOR)
        field(HLSMANIFESTS_DESCRIPTOR)
        field(LOWLATENCYHLSMANIFESTS_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(ORIGINENDPOINTNAME_DESCRIPTOR)
        field(SEGMENT_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHANNELGROUPNAME_DESCRIPTOR.index -> builder.channelGroupName = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CONTAINERTYPE_DESCRIPTOR.index -> builder.containerType = deserializeString().let { ContainerType.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DASHMANIFESTS_DESCRIPTOR.index -> builder.dashManifests =
                    deserializer.deserializeList(DASHMANIFESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetDashManifestConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetDashManifestConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ETAG_DESCRIPTOR.index -> builder.eTag = deserializeString()
                HLSMANIFESTS_DESCRIPTOR.index -> builder.hlsManifests =
                    deserializer.deserializeList(HLSMANIFESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetHlsManifestConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetHlsManifestConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOWLATENCYHLSMANIFESTS_DESCRIPTOR.index -> builder.lowLatencyHlsManifests =
                    deserializer.deserializeList(LOWLATENCYHLSMANIFESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetLowLatencyHlsManifestConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetLowLatencyHlsManifestConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                ORIGINENDPOINTNAME_DESCRIPTOR.index -> builder.originEndpointName = deserializeString()
                SEGMENT_DESCRIPTOR.index -> builder.segment = deserializeSegmentDocument(deserializer)
                STARTOVERWINDOWSECONDS_DESCRIPTOR.index -> builder.startoverWindowSeconds = deserializeInt()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
