// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateOriginEndpointRequest private constructor(builder: Builder) {
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String? = builder.channelGroupName
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file.
     */
    public val containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = builder.containerType
    /**
     * A DASH manifest configuration.
     */
    public val dashManifests: List<CreateDashManifestConfiguration>? = builder.dashManifests
    /**
     * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource's current entity tag, the update request will be rejected.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * An HTTP live streaming (HLS) manifest configuration.
     */
    public val hlsManifests: List<CreateHlsManifestConfiguration>? = builder.hlsManifests
    /**
     * A low-latency HLS manifest configuration.
     */
    public val lowLatencyHlsManifests: List<CreateLowLatencyHlsManifestConfiguration>? = builder.lowLatencyHlsManifests
    /**
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
     */
    public val originEndpointName: kotlin.String? = builder.originEndpointName
    /**
     * The segment configuration, including the segment name, duration, and other configuration values.
     */
    public val segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = builder.segment
    /**
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).
     */
    public val startoverWindowSeconds: kotlin.Int? = builder.startoverWindowSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOriginEndpointRequest(")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("containerType=$containerType,")
        append("dashManifests=$dashManifests,")
        append("description=$description,")
        append("eTag=$eTag,")
        append("hlsManifests=$hlsManifests,")
        append("lowLatencyHlsManifests=$lowLatencyHlsManifests,")
        append("originEndpointName=$originEndpointName,")
        append("segment=$segment,")
        append("startoverWindowSeconds=$startoverWindowSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelGroupName?.hashCode() ?: 0
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (dashManifests?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (lowLatencyHlsManifests?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName?.hashCode() ?: 0)
        result = 31 * result + (segment?.hashCode() ?: 0)
        result = 31 * result + (startoverWindowSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOriginEndpointRequest

        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (containerType != other.containerType) return false
        if (dashManifests != other.dashManifests) return false
        if (description != other.description) return false
        if (eTag != other.eTag) return false
        if (hlsManifests != other.hlsManifests) return false
        if (lowLatencyHlsManifests != other.lowLatencyHlsManifests) return false
        if (originEndpointName != other.originEndpointName) return false
        if (segment != other.segment) return false
        if (startoverWindowSeconds != other.startoverWindowSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file.
         */
        public var containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = null
        /**
         * A DASH manifest configuration.
         */
        public var dashManifests: List<CreateDashManifestConfiguration>? = null
        /**
         * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
         */
        public var description: kotlin.String? = null
        /**
         * The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource's current entity tag, the update request will be rejected.
         */
        public var eTag: kotlin.String? = null
        /**
         * An HTTP live streaming (HLS) manifest configuration.
         */
        public var hlsManifests: List<CreateHlsManifestConfiguration>? = null
        /**
         * A low-latency HLS manifest configuration.
         */
        public var lowLatencyHlsManifests: List<CreateLowLatencyHlsManifestConfiguration>? = null
        /**
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The segment configuration, including the segment name, duration, and other configuration values.
         */
        public var segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = null
        /**
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is 1,209,600 seconds (14 days).
         */
        public var startoverWindowSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest) : this() {
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.containerType = x.containerType
            this.dashManifests = x.dashManifests
            this.description = x.description
            this.eTag = x.eTag
            this.hlsManifests = x.hlsManifests
            this.lowLatencyHlsManifests = x.lowLatencyHlsManifests
            this.originEndpointName = x.originEndpointName
            this.segment = x.segment
            this.startoverWindowSeconds = x.startoverWindowSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest = UpdateOriginEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Segment] inside the given [block]
         */
        public fun segment(block: aws.sdk.kotlin.services.mediapackagev2.model.Segment.Builder.() -> kotlin.Unit) {
            this.segment = aws.sdk.kotlin.services.mediapackagev2.model.Segment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
