// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration of the origin endpoint.
 */
public class OriginEndpointListConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) associated with the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String = requireNotNull(builder.channelGroupName) { "A non-null value must be provided for channelGroupName" }
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file.
     */
    public val containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType = requireNotNull(builder.containerType) { "A non-null value must be provided for containerType" }
    /**
     * The date and time the origin endpoint was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A DASH manifest configuration.
     */
    public val dashManifests: List<ListDashManifestConfiguration>? = builder.dashManifests
    /**
     * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An HTTP live streaming (HLS) manifest configuration.
     */
    public val hlsManifests: List<ListHlsManifestConfiguration>? = builder.hlsManifests
    /**
     * A low-latency HLS manifest configuration.
     */
    public val lowLatencyHlsManifests: List<ListLowLatencyHlsManifestConfiguration>? = builder.lowLatencyHlsManifests
    /**
     * The date and time the origin endpoint was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
     */
    public val originEndpointName: kotlin.String = requireNotNull(builder.originEndpointName) { "A non-null value must be provided for originEndpointName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.OriginEndpointListConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginEndpointListConfiguration(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("containerType=$containerType,")
        append("createdAt=$createdAt,")
        append("dashManifests=$dashManifests,")
        append("description=$description,")
        append("hlsManifests=$hlsManifests,")
        append("lowLatencyHlsManifests=$lowLatencyHlsManifests,")
        append("modifiedAt=$modifiedAt,")
        append("originEndpointName=$originEndpointName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelGroupName.hashCode())
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (containerType.hashCode())
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dashManifests?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (lowLatencyHlsManifests?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (originEndpointName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginEndpointListConfiguration

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (containerType != other.containerType) return false
        if (createdAt != other.createdAt) return false
        if (dashManifests != other.dashManifests) return false
        if (description != other.description) return false
        if (hlsManifests != other.hlsManifests) return false
        if (lowLatencyHlsManifests != other.lowLatencyHlsManifests) return false
        if (modifiedAt != other.modifiedAt) return false
        if (originEndpointName != other.originEndpointName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.OriginEndpointListConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) associated with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one or more media streams, such as audio and video, into a single file.
         */
        public var containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = null
        /**
         * The date and time the origin endpoint was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A DASH manifest configuration.
         */
        public var dashManifests: List<ListDashManifestConfiguration>? = null
        /**
         * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
         */
        public var description: kotlin.String? = null
        /**
         * An HTTP live streaming (HLS) manifest configuration.
         */
        public var hlsManifests: List<ListHlsManifestConfiguration>? = null
        /**
         * A low-latency HLS manifest configuration.
         */
        public var lowLatencyHlsManifests: List<ListLowLatencyHlsManifestConfiguration>? = null
        /**
         * The date and time the origin endpoint was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
         */
        public var originEndpointName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.OriginEndpointListConfiguration) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.containerType = x.containerType
            this.createdAt = x.createdAt
            this.dashManifests = x.dashManifests
            this.description = x.description
            this.hlsManifests = x.hlsManifests
            this.lowLatencyHlsManifests = x.lowLatencyHlsManifests
            this.modifiedAt = x.modifiedAt
            this.originEndpointName = x.originEndpointName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.OriginEndpointListConfiguration = OriginEndpointListConfiguration(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelGroupName == null) channelGroupName = ""
            if (channelName == null) channelName = ""
            if (containerType == null) containerType = ContainerType.SdkUnknown("no value provided")
            if (originEndpointName == null) originEndpointName = ""
            return this
        }
    }
}
