// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetOriginEndpointResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) associated with the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String = requireNotNull(builder.channelGroupName) { "A non-null value must be provided for channelGroupName" }
    /**
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The type of container attached to this origin endpoint.
     */
    public val containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType = requireNotNull(builder.containerType) { "A non-null value must be provided for containerType" }
    /**
     * The date and time the origin endpoint was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description for your origin endpoint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An HTTP live streaming (HLS) manifest configuration.
     */
    public val hlsManifests: List<GetHlsManifestConfiguration>? = builder.hlsManifests
    /**
     * A low-latency HLS manifest configuration.
     */
    public val lowLatencyHlsManifests: List<GetLowLatencyHlsManifestConfiguration>? = builder.lowLatencyHlsManifests
    /**
     * The date and time the origin endpoint was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
     */
    public val originEndpointName: kotlin.String = requireNotNull(builder.originEndpointName) { "A non-null value must be provided for originEndpointName" }
    /**
     * The segment configuration, including the segment name, duration, and other configuration values.
     */
    public val segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = builder.segment
    /**
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.
     */
    public val startoverWindowSeconds: kotlin.Int? = builder.startoverWindowSeconds
    /**
     * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetOriginEndpointResponse(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("channelName=$channelName,")
        append("containerType=$containerType,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("hlsManifests=$hlsManifests,")
        append("lowLatencyHlsManifests=$lowLatencyHlsManifests,")
        append("modifiedAt=$modifiedAt,")
        append("originEndpointName=$originEndpointName,")
        append("segment=$segment,")
        append("startoverWindowSeconds=$startoverWindowSeconds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelGroupName.hashCode())
        result = 31 * result + (channelName.hashCode())
        result = 31 * result + (containerType.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (lowLatencyHlsManifests?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (originEndpointName.hashCode())
        result = 31 * result + (segment?.hashCode() ?: 0)
        result = 31 * result + (startoverWindowSeconds ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetOriginEndpointResponse

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (channelName != other.channelName) return false
        if (containerType != other.containerType) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (hlsManifests != other.hlsManifests) return false
        if (lowLatencyHlsManifests != other.lowLatencyHlsManifests) return false
        if (modifiedAt != other.modifiedAt) return false
        if (originEndpointName != other.originEndpointName) return false
        if (segment != other.segment) return false
        if (startoverWindowSeconds != other.startoverWindowSeconds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) associated with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for your account in the AWS Region and channel group.
         */
        public var channelName: kotlin.String? = null
        /**
         * The type of container attached to this origin endpoint.
         */
        public var containerType: aws.sdk.kotlin.services.mediapackagev2.model.ContainerType? = null
        /**
         * The date and time the origin endpoint was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for your origin endpoint.
         */
        public var description: kotlin.String? = null
        /**
         * An HTTP live streaming (HLS) manifest configuration.
         */
        public var hlsManifests: List<GetHlsManifestConfiguration>? = null
        /**
         * A low-latency HLS manifest configuration.
         */
        public var lowLatencyHlsManifests: List<GetLowLatencyHlsManifestConfiguration>? = null
        /**
         * The date and time the origin endpoint was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and must be unique for your account in the AWS Region and channel.
         */
        public var originEndpointName: kotlin.String? = null
        /**
         * The segment configuration, including the segment name, duration, and other configuration values.
         */
        public var segment: aws.sdk.kotlin.services.mediapackagev2.model.Segment? = null
        /**
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.
         */
        public var startoverWindowSeconds: kotlin.Int? = null
        /**
         * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointResponse) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.channelName = x.channelName
            this.containerType = x.containerType
            this.createdAt = x.createdAt
            this.description = x.description
            this.hlsManifests = x.hlsManifests
            this.lowLatencyHlsManifests = x.lowLatencyHlsManifests
            this.modifiedAt = x.modifiedAt
            this.originEndpointName = x.originEndpointName
            this.segment = x.segment
            this.startoverWindowSeconds = x.startoverWindowSeconds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointResponse = GetOriginEndpointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.Segment] inside the given [block]
         */
        public fun segment(block: aws.sdk.kotlin.services.mediapackagev2.model.Segment.Builder.() -> kotlin.Unit) {
            this.segment = aws.sdk.kotlin.services.mediapackagev2.model.Segment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelGroupName == null) channelGroupName = ""
            if (channelName == null) channelName = ""
            if (containerType == null) containerType = ContainerType.SdkUnknown("no value provided")
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (originEndpointName == null) originEndpointName = ""
            return this
        }
    }
}
