// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.serde

import aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.MediaPackageV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOriginEndpointPolicyOperationDeserializer: HttpDeserialize<GetOriginEndpointPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetOriginEndpointPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetOriginEndpointPolicyError(context, call)
        }
        val builder = GetOriginEndpointPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOriginEndpointPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetOriginEndpointPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaPackageV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOriginEndpointPolicyOperationBody(builder: GetOriginEndpointPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelGroupName"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val ORIGINENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginEndpointName"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Policy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELGROUPNAME_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(ORIGINENDPOINTNAME_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELGROUPNAME_DESCRIPTOR.index -> builder.channelGroupName = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                ORIGINENDPOINTNAME_DESCRIPTOR.index -> builder.originEndpointName = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
