// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateChannelGroupResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) associated with the resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
     */
    public val channelGroupName: kotlin.String = requireNotNull(builder.channelGroupName) { "A non-null value must be provided for channelGroupName" }
    /**
     * The date and time the channel group was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description for your channel group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The output domain where the source stream should be sent. Integrate the egress domain with a downstream CDN (such as Amazon CloudFront) or playback device.
     */
    public val egressDomain: kotlin.String = requireNotNull(builder.egressDomain) { "A non-null value must be provided for egressDomain" }
    /**
     * The date and time the channel group was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The comma-separated list of tag key:value pairs assigned to the channel group.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelGroupResponse(")
        append("arn=$arn,")
        append("channelGroupName=$channelGroupName,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("egressDomain=$egressDomain,")
        append("modifiedAt=$modifiedAt,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (channelGroupName.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (egressDomain.hashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelGroupResponse

        if (arn != other.arn) return false
        if (channelGroupName != other.channelGroupName) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (egressDomain != other.egressDomain) return false
        if (modifiedAt != other.modifiedAt) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) associated with the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must be unique for your account in the AWS Region.
         */
        public var channelGroupName: kotlin.String? = null
        /**
         * The date and time the channel group was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for your channel group.
         */
        public var description: kotlin.String? = null
        /**
         * The output domain where the source stream should be sent. Integrate the egress domain with a downstream CDN (such as Amazon CloudFront) or playback device.
         */
        public var egressDomain: kotlin.String? = null
        /**
         * The date and time the channel group was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The comma-separated list of tag key:value pairs assigned to the channel group.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupResponse) : this() {
            this.arn = x.arn
            this.channelGroupName = x.channelGroupName
            this.createdAt = x.createdAt
            this.description = x.description
            this.egressDomain = x.egressDomain
            this.modifiedAt = x.modifiedAt
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupResponse = CreateChannelGroupResponse(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (channelGroupName == null) channelGroupName = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (egressDomain == null) egressDomain = ""
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
