// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mediapackagev2.auth.DefaultMediaPackageV2AuthSchemeProvider
import aws.sdk.kotlin.services.mediapackagev2.auth.MediaPackageV2AuthSchemeProvider
import aws.sdk.kotlin.services.mediapackagev2.endpoints.DefaultMediaPackageV2EndpointProvider
import aws.sdk.kotlin.services.mediapackagev2.endpoints.MediaPackageV2EndpointParameters
import aws.sdk.kotlin.services.mediapackagev2.endpoints.MediaPackageV2EndpointProvider
import aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupRequest
import aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelGroupResponse
import aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelRequest
import aws.sdk.kotlin.services.mediapackagev2.model.CreateChannelResponse
import aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelGroupRequest
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelGroupResponse
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelRequest
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteChannelResponse
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteOriginEndpointPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackagev2.model.DeleteOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelGroupRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelGroupResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetChannelResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackagev2.model.GetOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelGroupsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelGroupsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListOriginEndpointsRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListOriginEndpointsResponse
import aws.sdk.kotlin.services.mediapackagev2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediapackagev2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediapackagev2.model.PutChannelPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.PutChannelPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.PutOriginEndpointPolicyRequest
import aws.sdk.kotlin.services.mediapackagev2.model.PutOriginEndpointPolicyResponse
import aws.sdk.kotlin.services.mediapackagev2.model.TagResourceRequest
import aws.sdk.kotlin.services.mediapackagev2.model.TagResourceResponse
import aws.sdk.kotlin.services.mediapackagev2.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediapackagev2.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateChannelGroupRequest
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateChannelGroupResponse
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateChannelRequest
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateChannelResponse
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MediaPackageV2"
public const val SdkVersion: String = "1.0.43"
public const val ServiceApiVersion: String = "2022-12-25"

/**
 * This guide is intended for creating AWS Elemental MediaPackage resources in MediaPackage Version 2 (v2) starting from May 2023. To get started with MediaPackage v2, create your MediaPackage resources. There isn't an automated process to migrate your resources from MediaPackage v1 to MediaPackage v2.
 *
 * The names of the entities that you use to access this API, like URLs and ARNs, all have the versioning information added, like "v2", to distinguish from the prior version. If you used MediaPackage prior to this release, you can't use the MediaPackage v2 CLI or the MediaPackage v2 API to access any MediaPackage v1 resources.
 *
 * If you created resources in MediaPackage v1, use video on demand (VOD) workflows, and aren't looking to migrate to MediaPackage v2 yet, see the [MediaPackage v1 Live API Reference](https://docs.aws.amazon.com/mediapackage/latest/apireference/what-is.html).
 *
 * This is the AWS Elemental MediaPackage v2 Live REST API Reference. It describes all the MediaPackage API operations for live content in detail, and provides sample requests, responses, and errors for the supported web services protocols.
 *
 * We assume that you have the IAM permissions that you need to use MediaPackage via the REST API. We also assume that you are familiar with the features and operations of MediaPackage, as described in the AWS Elemental MediaPackage User Guide.
 */
public interface MediaPackageV2Client : SdkClient {
    /**
     * MediaPackageV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaPackageV2Client, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaPackageV2",
                "MEDIAPACKAGEV2",
                "mediapackagev2",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaPackageV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaPackageV2Client = DefaultMediaPackageV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaPackageV2EndpointProvider = builder.endpointProvider ?: DefaultMediaPackageV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaPackageV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaPackageV2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaPackageV2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaPackageV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaPackageV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that request the content. You can create only one channel with each request. We recommend that you spread out channels between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateChannel.sample
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You can create only one channel group with each request.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateChannelGroup.sample
     */
    public suspend fun createChannelGroup(input: CreateChannelGroupRequest): CreateChannelGroupResponse

    /**
     * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only one endpoint with each request.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateOriginEndpoint.sample
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateOriginEndpoint.sample2
     */
    public suspend fun createOriginEndpoint(input: CreateOriginEndpointRequest): CreateOriginEndpointResponse

    /**
     * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's origin endpoints before you can delete the channel.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannel.sample
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create a new channel group to replace it.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannelGroup.sample
     */
    public suspend fun deleteChannelGroup(input: DeleteChannelGroupRequest): DeleteChannelGroupResponse

    /**
     * Delete a channel policy.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannelPolicy.sample
     */
    public suspend fun deleteChannelPolicy(input: DeleteChannelPolicyRequest): DeleteChannelPolicyResponse

    /**
     * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to playback requests. You must delete all endpoints from a channel before you can delete the channel.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteOriginEndpoint.sample
     */
    public suspend fun deleteOriginEndpoint(input: DeleteOriginEndpointRequest): DeleteOriginEndpointResponse

    /**
     * Delete an origin endpoint policy.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteOriginEndpointPolicy.sample
     */
    public suspend fun deleteOriginEndpointPolicy(input: DeleteOriginEndpointPolicyRequest): DeleteOriginEndpointPolicyResponse

    /**
     * Retrieves the specified channel that's configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannel.sample
     */
    public suspend fun getChannel(input: GetChannelRequest): GetChannelResponse

    /**
     * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannelGroup.sample
     */
    public suspend fun getChannelGroup(input: GetChannelGroupRequest): GetChannelGroupResponse

    /**
     * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannelPolicy.sample
     */
    public suspend fun getChannelPolicy(input: GetChannelPolicyRequest): GetChannelPolicyResponse

    /**
     * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback URL and to view the packaging settings that it's currently using.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetOriginEndpoint.sample
     */
    public suspend fun getOriginEndpoint(input: GetOriginEndpointRequest): GetOriginEndpointResponse

    /**
     * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetOriginEndpointPolicy.sample
     */
    public suspend fun getOriginEndpointPolicy(input: GetOriginEndpointPolicyRequest): GetOriginEndpointPolicyResponse

    /**
     * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListChannelGroups.sample
     */
    public suspend fun listChannelGroups(input: ListChannelGroupsRequest = ListChannelGroupsRequest { }): ListChannelGroupsResponse

    /**
     * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListChannels.sample
     */
    public suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse

    /**
     * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListOriginEndpoints.sample
     */
    public suspend fun listOriginEndpoints(input: ListOriginEndpointsRequest): ListOriginEndpointsResponse

    /**
     * Lists the tags assigned to a resource.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources. You can attach only one policy with each request.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.PutChannelPolicy.sample
     */
    public suspend fun putChannelPolicy(input: PutChannelPolicyRequest): PutChannelPolicyResponse

    /**
     * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.PutOriginEndpointPolicy.sample
     */
    public suspend fun putOriginEndpointPolicy(input: PutOriginEndpointPolicyRequest): PutOriginEndpointPolicyResponse

    /**
     * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You can't edit the name of the channel or CloudFront distribution details.
     *
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateChannel.sample
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Update the specified channel group. You can edit the description on a channel group for easier identification later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
     *
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateChannelGroup.sample
     */
    public suspend fun updateChannelGroup(input: UpdateChannelGroupRequest): UpdateChannelGroupResponse

    /**
     * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing experience. You can't edit the name of the endpoint.
     *
     * Any edits you make that impact the video output may not be reflected for a few minutes.
     *
     * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateOriginEndpoint.sample
     */
    public suspend fun updateOriginEndpoint(input: UpdateOriginEndpointRequest): UpdateOriginEndpointResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaPackageV2Client.withConfig(block: MediaPackageV2Client.Config.Builder.() -> Unit): MediaPackageV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaPackageV2Client(newConfig)
}

/**
 * Create a channel to start receiving content streams. The channel represents the input to MediaPackage for incoming live content from an encoder such as AWS Elemental MediaLive. The channel receives content, and after packaging it, outputs it through an origin endpoint to downstream devices (such as video players or CDNs) that request the content. You can create only one channel with each request. We recommend that you spread out channels between channel groups, such as putting redundant channels in the same AWS Region in different channel groups.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateChannel.sample
 */
public suspend inline fun MediaPackageV2Client.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Create a channel group to group your channels and origin endpoints. A channel group is the top-level resource that consists of channels and origin endpoints that are associated with it and that provides predictable URLs for stream delivery. All channels and origin endpoints within the channel group are guaranteed to share the DNS. You can create only one channel group with each request.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateChannelGroup.sample
 */
public suspend inline fun MediaPackageV2Client.createChannelGroup(crossinline block: CreateChannelGroupRequest.Builder.() -> Unit): CreateChannelGroupResponse = createChannelGroup(CreateChannelGroupRequest.Builder().apply(block).build())

/**
 * The endpoint is attached to a channel, and represents the output of the live content. You can associate multiple endpoints to a single channel. Each endpoint gives players and downstream CDNs (such as Amazon CloudFront) access to the content for playback. Content can't be served from a channel until it has an endpoint. You can create only one endpoint with each request.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateOriginEndpoint.sample
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.CreateOriginEndpoint.sample2
 */
public suspend inline fun MediaPackageV2Client.createOriginEndpoint(crossinline block: CreateOriginEndpointRequest.Builder.() -> Unit): CreateOriginEndpointResponse = createOriginEndpoint(CreateOriginEndpointRequest.Builder().apply(block).build())

/**
 * Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You must delete the channel's origin endpoints before you can delete the channel.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannel.sample
 */
public suspend inline fun MediaPackageV2Client.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Delete a channel group. You must delete the channel group's channels and origin endpoints before you can delete the channel group. If you delete a channel group, you'll lose access to the egress domain and will have to create a new channel group to replace it.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannelGroup.sample
 */
public suspend inline fun MediaPackageV2Client.deleteChannelGroup(crossinline block: DeleteChannelGroupRequest.Builder.() -> Unit): DeleteChannelGroupResponse = deleteChannelGroup(DeleteChannelGroupRequest.Builder().apply(block).build())

/**
 * Delete a channel policy.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteChannelPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.deleteChannelPolicy(crossinline block: DeleteChannelPolicyRequest.Builder.() -> Unit): DeleteChannelPolicyResponse = deleteChannelPolicy(DeleteChannelPolicyRequest.Builder().apply(block).build())

/**
 * Origin endpoints can serve content until they're deleted. Delete the endpoint if it should no longer respond to playback requests. You must delete all endpoints from a channel before you can delete the channel.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteOriginEndpoint.sample
 */
public suspend inline fun MediaPackageV2Client.deleteOriginEndpoint(crossinline block: DeleteOriginEndpointRequest.Builder.() -> Unit): DeleteOriginEndpointResponse = deleteOriginEndpoint(DeleteOriginEndpointRequest.Builder().apply(block).build())

/**
 * Delete an origin endpoint policy.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.DeleteOriginEndpointPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.deleteOriginEndpointPolicy(crossinline block: DeleteOriginEndpointPolicyRequest.Builder.() -> Unit): DeleteOriginEndpointPolicyResponse = deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the specified channel that's configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannel.sample
 */
public suspend inline fun MediaPackageV2Client.getChannel(crossinline block: GetChannelRequest.Builder.() -> Unit): GetChannelResponse = getChannel(GetChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the specified channel group that's configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannelGroup.sample
 */
public suspend inline fun MediaPackageV2Client.getChannelGroup(crossinline block: GetChannelGroupRequest.Builder.() -> Unit): GetChannelGroupResponse = getChannelGroup(GetChannelGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetChannelPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.getChannelPolicy(crossinline block: GetChannelPolicyRequest.Builder.() -> Unit): GetChannelPolicyResponse = getChannelPolicy(GetChannelPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to obtain its playback URL and to view the packaging settings that it's currently using.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetOriginEndpoint.sample
 */
public suspend inline fun MediaPackageV2Client.getOriginEndpoint(crossinline block: GetOriginEndpointRequest.Builder.() -> Unit): GetOriginEndpointResponse = getOriginEndpoint(GetOriginEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves the specified origin endpoint policy that's configured in AWS Elemental MediaPackage.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.GetOriginEndpointPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.getOriginEndpointPolicy(crossinline block: GetOriginEndpointPolicyRequest.Builder.() -> Unit): GetOriginEndpointPolicyResponse = getOriginEndpointPolicy(GetOriginEndpointPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including the channels and origin endpoints that are associated with it.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListChannelGroups.sample
 */
public suspend inline fun MediaPackageV2Client.listChannelGroups(crossinline block: ListChannelGroupsRequest.Builder.() -> Unit): ListChannelGroupsResponse = listChannelGroups(ListChannelGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves all channels in a specific channel group that are configured in AWS Elemental MediaPackage, including the origin endpoints that are associated with it.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListChannels.sample
 */
public suspend inline fun MediaPackageV2Client.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental MediaPackage.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListOriginEndpoints.sample
 */
public suspend inline fun MediaPackageV2Client.listOriginEndpoints(crossinline block: ListOriginEndpointsRequest.Builder.() -> Unit): ListOriginEndpointsResponse = listOriginEndpoints(ListOriginEndpointsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.ListTagsForResource.sample
 */
public suspend inline fun MediaPackageV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Attaches an IAM policy to the specified channel. With policies, you can specify who has access to AWS resources and what actions they can perform on those resources. You can attach only one policy with each request.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.PutChannelPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.putChannelPolicy(crossinline block: PutChannelPolicyRequest.Builder.() -> Unit): PutChannelPolicyResponse = putChannelPolicy(PutChannelPolicyRequest.Builder().apply(block).build())

/**
 * Attaches an IAM policy to the specified origin endpoint. You can attach only one policy with each request.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.PutOriginEndpointPolicy.sample
 */
public suspend inline fun MediaPackageV2Client.putOriginEndpointPolicy(crossinline block: PutOriginEndpointPolicyRequest.Builder.() -> Unit): PutOriginEndpointPolicyResponse = putOriginEndpointPolicy(PutOriginEndpointPolicyRequest.Builder().apply(block).build())

/**
 * Assigns one of more tags (key-value pairs) to the specified MediaPackage resource.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the TagResource operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.TagResource.sample
 */
public suspend inline fun MediaPackageV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UntagResource.sample
 */
public suspend inline fun MediaPackageV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the specified channel. You can edit if MediaPackage sends ingest or egress access logs to the CloudWatch log group, if content will be encrypted, the description on a channel, and your channel's policy settings. You can't edit the name of the channel or CloudFront distribution details.
 *
 * Any edits you make that impact the video output may not be reflected for a few minutes.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateChannel.sample
 */
public suspend inline fun MediaPackageV2Client.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Update the specified channel group. You can edit the description on a channel group for easier identification later from the AWS Elemental MediaPackage console. You can't edit the name of the channel group.
 *
 * Any edits you make that impact the video output may not be reflected for a few minutes.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateChannelGroup.sample
 */
public suspend inline fun MediaPackageV2Client.updateChannelGroup(crossinline block: UpdateChannelGroupRequest.Builder.() -> Unit): UpdateChannelGroupResponse = updateChannelGroup(UpdateChannelGroupRequest.Builder().apply(block).build())

/**
 * Update the specified origin endpoint. Edit the packaging preferences on an endpoint to optimize the viewing experience. You can't edit the name of the endpoint.
 *
 * Any edits you make that impact the video output may not be reflected for a few minutes.
 *
 * @sample aws.sdk.kotlin.services.mediapackagev2.samples.UpdateOriginEndpoint.sample
 */
public suspend inline fun MediaPackageV2Client.updateOriginEndpoint(crossinline block: UpdateOriginEndpointRequest.Builder.() -> Unit): UpdateOriginEndpointResponse = updateOriginEndpoint(UpdateOriginEndpointRequest.Builder().apply(block).build())
