// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.transform

import aws.sdk.kotlin.services.mediapackagev2.model.ContainerType
import aws.sdk.kotlin.services.mediapackagev2.model.CreateHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.Segment
import aws.sdk.kotlin.services.mediapackagev2.model.UpdateOriginEndpointRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateOriginEndpointOperationSerializer: HttpSerialize<UpdateOriginEndpointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateOriginEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "channelGroup",
                "${input.channelGroupName}".encodeLabel(),
                "channel",
                "${input.channelName}".encodeLabel(),
                "originEndpoint",
                "${input.originEndpointName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateOriginEndpointOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateOriginEndpointOperationBody(context: ExecutionContext, input: UpdateOriginEndpointRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTAINERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ContainerType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val HLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HlsManifests"))
    val LOWLATENCYHLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LowLatencyHlsManifests"))
    val SEGMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Segment"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StartoverWindowSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINERTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HLSMANIFESTS_DESCRIPTOR)
        field(LOWLATENCYHLSMANIFESTS_DESCRIPTOR)
        field(SEGMENT_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.containerType?.let { field(CONTAINERTYPE_DESCRIPTOR, it.value) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.hlsManifests != null) {
            listField(HLSMANIFESTS_DESCRIPTOR) {
                for (el0 in input.hlsManifests) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCreateHlsManifestConfigurationDocument))
                }
            }
        }
        if (input.lowLatencyHlsManifests != null) {
            listField(LOWLATENCYHLSMANIFESTS_DESCRIPTOR) {
                for (el0 in input.lowLatencyHlsManifests) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCreateLowLatencyHlsManifestConfigurationDocument))
                }
            }
        }
        input.segment?.let { field(SEGMENT_DESCRIPTOR, it, ::serializeSegmentDocument) }
        input.startoverWindowSeconds?.let { field(STARTOVERWINDOWSECONDS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
